<?php namespace Visiosoft\CartsModule\Cart\Command;

use Visiosoft\CartsModule\Cart\CartProcessor;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;

/**
 * Class ProcessCart
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class ProcessCart
{

    /**
     * The cart instance.
     *
     * @var CartInterface
     */
    protected $cart;

    /**
     * Create a new ProcessCart instance.
     *
     * @param CartInterface $cart
     */
    public function __construct(CartInterface $cart)
    {
        $this->cart = $cart;
    }

    /**
     * Handle the command.
     *
     * @param CartProcessor $processor
     */
    public function handle(CartProcessor $processor)
    {
        $processor->process($this->cart);
    }
}
