<?php namespace Visiosoft\CartsModule;

use Visiosoft\CartsModule\Cart\Command\GetCart;
use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Anomaly\Streams\Platform\Support\Decorator;

/**
 * Class CartsModulePlugin
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Anomaly\CartsModule
 */
class CartsModulePlugin extends Plugin
{

    /**
     * Get the functions.
     *
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'cart',
                function ($instance = 'default') {
                    return (new Decorator())->decorate($this->dispatch(new GetCart($instance)));
                }
            ),
            new \Twig_SimpleFunction(
                'cart_count',
                function ($update = null) {
                    return cart_count($update);
                }
            ),
        ];
    }

}
