<?php namespace Visiosoft\CartsModule\Cart\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class CartTableBuilder extends TableBuilder
{

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'entry.last_modified' => [
            'sort_column' => 'updated_at',
        ],
        'ip_address',
        'entry.items.quantity',
        'user_name' => [
            'value' => 'entry.user.name ?: "Guest"'
        ],
        'user_gsm_phone' => [
            'value' => 'entry.user.gsm_phone ?: "Guest"'
        ],
        'user_email' => [
            'value' => 'entry.user.email ?: "Guest"'
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'view_items' => [
            'type' => 'info',
            'href' => 'admin/carts/view-cart-items/{entry.id}',
        ],
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete',
    ];

}