<?php namespace Visiosoft\CartsModule\Http\Controller;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Contracts\Events\Dispatcher;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Redirect;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\CartsModule\Cart\Command\PackageCartRemoved;
use Visiosoft\CartsModule\Cart\Event\CartsPay;
use Visiosoft\CartsModule\Cart\Event\Payment;
use Visiosoft\CartsModule\Cart\Event\PaymentPending;
use Visiosoft\CartsModule\Cart\Event\PaymentSuccess;
use Visiosoft\CouponModule\Code\Command\calculateTotal;
use Visiosoft\CouponModule\Code\Command\calculateTotalWithCouponCode;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Events\OrderCreated;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;
use Visiosoft\ProfileModule\Adress\AdressModel;

class CartsController extends PublicController
{
    private $advModel;
    private $adressModel;
    private $countryModel;
    private $orderModel;
    private $orderdetailModel;
    private $currency;

    use \Visiosoft\CartsModule\Cart\Traits\calculateTotal;

    public function __construct(
        AdvModel $advModel,
        AdressModel $adressModel,
        CountryModel $countryModel,
        OrderModel $orderModel,
        OrderdetailModel $orderdetailModel,
        Currency $currency
    )
    {
        parent::__construct();
        $this->advModel = $advModel;
        $this->adressModel = $adressModel;
        $this->countryModel = $countryModel;
        $this->orderModel = $orderModel;
        $this->orderdetailModel = $orderdetailModel;
        $this->currency = $currency;
    }

    /**
     * View the contents of a cart.
     *
     * @return View|mixed
     * @throws BindingResolutionException
     */
    public function view()
    {
        $cart = $this->dispatch(new GetCart());
        foreach ($cart->items as $index => $item) {
            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $stock_control = $this->advModel->stockControl($item->entry_id, $item->quantity);
                $product_control = $this->advModel->is_active($item->entry_id);
                if ($stock_control == 0) {
                    $cart->remove($item->id); //Remove item in cart
                    $this->messages->info("'" . $item->name . "' => " . trans('visiosoft.module.carts::message.error1in1'));
                }
                if ($product_control == 0) {
                    $cart->remove($item->id); //Remove item in cart
                    $this->messages->info("'" . $item->name . "' => " . trans('visiosoft.module.carts::message.error2'));
                }

                $cart->items[$index]->detail_url = $this->advModel->getAdvDetailLinkByAdId($item->entry_id);
                $cart->items[$index]->cover_photo = $this->advModel->GetAdsDefaultCoverImageByAdId($item->entry_id);
            } else {
                $cart->items[$index]->cover_photo = $this->dispatch(new MakeImageInstance('visiosoft.theme.base::images/no-image.png', 'img'))->url();
                $cart->items[$index]->detail_url = "#";
            }
        }


        $total = $cart->total;
        $discount = 0;

        $couponCode = null;
        if (is_module_installed('visiosoft.module.coupon')) {
            $calculate = $this->calculateTotal();
            $total = $calculate['total'];
            $discount = $calculate['discount'];
            $couponCode = $calculate['couponCode'];
        }

        $this->template->set('meta_title', 'Cart');
        return $this->view->make('visiosoft.module.carts::carts.view', compact('cart', 'total', 'discount', 'couponCode'));
    }


    public function bankOrder($pay_type, $order_id)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }

        $cart = $this->dispatch(new GetCart());

        //Stock And Product Control
        foreach ($cart->items as $item) {
            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $stock_control = $this->advModel->stockControl($item->entry_id, $item->quantity);
                $product_control = $this->advModel->is_active($item->entry_id);
                if ($stock_control == 0 || $product_control == 0) {
                    return route('visiosoft.module.carts::cart');
                }
            }
        }

        $items = $cart->getItems();

        foreach ($items as $item) {
            if ($item->entry_type == 'Visiosoft\BalancesModule\Balance\BalanceModel') {
                $balanceController = app(\Visiosoft\BalancesModule\Http\Controller\BalancesFrontController::class);
                $balanceCartUpdate = $balanceController->cartUpdate($item->entry_id, $cart, $pay_type);
                if (!$balanceCartUpdate) {
                    $result = false;
                }
            } else if ($item->entry_type == 'Visiosoft\PackagesModule\Package\PackageModel') {
                $packages = new PackageModel();
                $packages->PendingStatus($item->entry_id);
            } else if ($item->entry_type == 'Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel') {
                $doping = DopingsDopingsEntryModel::find($item->entry_id);
                $doping->status = 'pending_approve';
                $doping->save();
            } else if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $this->advModel->updateStock($item->entry_id, $item->quantity);
            }
        }

        $cart->delete();

        $order = $this->orderModel->find($order_id);
        event(new PaymentPending($order));

        return redirect(route('orders::purchase_detail', ['id' => $order_id]));
    }

    public function fail($type = '')
    {
        $result = false;
        $cart = $this->dispatch(new GetCart());
        $message = $this->request->session()->get('message');
        if ($type == "balance") {
            $message = trans("visiosoft.module.carts::message.balancefail");
        }
        $this->messages->error($message);
        return redirect('cart');
    }

    public function success($type, Dispatcher $events, SettingRepositoryInterface $settings)
    {
        $cart = $this->dispatch(new GetCart());
        $items = $cart->getItems();

        $order_id = $this->request->cookie('order_id');

        foreach ($items as $item) {
            if ($item->entry_type == 'Visiosoft\BalancesModule\Balance\BalanceModel') {
                $balanceController = app(\Visiosoft\BalancesModule\Http\Controller\BalancesFrontController::class);
                $balanceCartUpdate = $balanceController->cartUpdate($item->entry_id, $cart, $type);
                if (!$balanceCartUpdate) {
                    $result = false;
                }
            } else if ($item->entry_type == 'Visiosoft\PackagesModule\Package\PackageModel') {
                $packageEntryModel = new PackageEntryModel();
                $userentryModel = new UserentryModel();
                $package_model = new \Visiosoft\PackagesModule\User\UserModel();

                if ($userForPackage = $package_model->newQuery()->find($item->entry_id) and !$userForPackage->isApproved()) {
                    $package = $package_model->status($userForPackage->id, 'approved');
                    $Packageentry = $packageEntryModel->getEntryPackage($package->package_id);
                    $userentryModel->addEntryUserArray($Packageentry, $package->id);
                }

            } else if ($item->entry_type == 'Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel') {
                $approve = app(\Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController::class);
                $approve->approve($item->entry_id);
            } else if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $this->advModel->updateStock($item->entry_id, $item->quantity);
            }
        }
        $cart->delete();

        //get last order
        $events->dispatch(new Payment($order_id, $settings));
        $order = $this->orderModel->find($order_id);

        event(new PaymentSuccess($order));

        $this->messages->success(trans('visiosoft.module.carts::message.payment_approved'));

        return Redirect::to(url('purchase/detail/' . $order_id));
    }

    public function addOrders($items, $status, $bill, $delivery, $order_type = 'order')
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $cart = $this->dispatch(new GetCart());


        $isOrdersModule = $this->advModel->is_enabled('orders');


        $total = $cart->total;
        $discount = 0;

        if (is_module_installed('visiosoft.module.coupon')) {
            $calculate = $this->calculateTotal();
            $total = $calculate['total'];
            $discount = $calculate['discount'];
            $couponCode = $calculate['couponCode'];
        }


        if ($isOrdersModule) {
            $order_id = $this->orderModel->create_orders([
                'user' => Auth::id(),
                'pay_type' => $order_type,
                'total' => $total,
                'subtotal' => $cart->subtotal,
                'shipping' => $cart->shipping,
                'tax' => $cart->tax,
                'currency' => setting_value('streams::currency'), 'status' => $status,
                'order_at' => date('Y-m-d H:i:s'),
                'bill_address' => $bill,
                'delivery_address' => $delivery
            ]);

            foreach ($items as $item) {
                switch ($item->entry_type) {
                    case 'Visiosoft\BalancesModule\Balance\BalanceModel':
                        $itemType = 'balance';
                        break;
                    case 'Visiosoft\PackagesModule\Package\PackageModel':
                        $itemType = 'package';
                        break;
                    case 'Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel':
                        $itemType = 'doping';
                        break;
                    case 'Visiosoft\AdvsModule\Adv\AdvModel':
                        $itemType = 'adv';
                        break;
                    case 'Visiosoft\SiteModule\Addon\AddonModel':
                        $itemType = 'site';
                        break;
                    case 'Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel':
                        $itemType = 'Subscription';
                        break;
                    case 'Visiosoft\AdvsModule\OptionConfiguration\OptionConfigurationModel':
                        $itemType = 'ads-configuration';
                        break;
                    case 'Visiosoft\StoreModule\Store\StoreModel':
                        $itemType = 'store';
                        break;
                }
                $total = $itemType === 'adv' ? $item->total : $item->price;
                $this->orderdetailModel->create_datail([
                    'item_id' => $item->entry_id,
                    'item_type' => $itemType,
                    'price' => $item->price,
                    'currency' => $item->currency,
                    'piece' => $item->quantity,
                    'commission' => 0,
                    'total' => $total,
                    'order' => $order_id,
                    'status' => 'awaiting_payment',
                    'notes' => $item->name
                ]);
            }
        }

        event(new OrderCreated($order_id));

        return $order_id;
    }

    public function review_cart()
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $address = $this->adressModel->getUserAdress();
        $cart = $this->dispatch(new GetCart());


        $total = $cart->total;
        $discount = 0;

        $couponCode = null;
        if (is_module_installed('visiosoft.module.coupon')) {
            $calculate = $this->calculateTotal();
            $total = $calculate['total'];
            $discount = $calculate['discount'];
            $couponCode = $calculate['couponCode'];
        }

        $showDeliveryAddress = count($cart->getItems()->where('entry_type', 'Visiosoft\AdvsModule\Adv\AdvModel'));
        $this->template->set('meta_title', 'Cart');
        $country = $this->countryModel->all();
        $pay_type = array();
        $pay_type = event(new CartsPay($pay_type));
        return $this->view->make(
            'visiosoft.module.carts::carts.review',
            compact('cart', 'pay_type', 'country', 'address', 'showDeliveryAddress', 'discount', 'total', 'couponCode')
        );

    }

    public function send_request(Request $request)
    {
        if (!isset($request->license) and $request->license != "on") {
            return back();
        }

        Cookie::queue(Cookie::make('delivery', $request->delivery_address, 84000));
        Cookie::queue(Cookie::make('bill', $request->bill_address, 84000));
        Cookie::queue(Cookie::make('pay', $request->pay_type, 84000));

        if (isset($request->bill_address)) {
            Cookie::queue(Cookie::make('bill', $request->bill_address, 84000));
        }

        $cart = $this->dispatch(new GetCart());
        $items = $cart->getItems();

        $order_id = $this->addOrders(
            $items,
            'pending',
            $request->bill_address,
            $request->delivery_address,
            $request->pay_type
        );
        Cookie::queue(Cookie::make('order_id', $order_id, 84000));

        if ($request->pay_type == 'paypal') {
            return $this->redirect->route('visiosoft.module.payment_paypal::payment', ['order_id' => $order_id]);
        } elseif ($request->pay_type == 'iyzico') {
            return Redirect::to(url('payment/iyzico'));
        } elseif ($request->pay_type == 'paytr') {
            return Redirect::to(url('payment/paytr/respond'));
        } elseif ($request->pay_type == 'balance') {
            return Redirect::to(url('payment/balance'));
        } elseif ($request->pay_type == 'stripe') {
            return Redirect::to(url('payment/stripe'));
        } elseif ($request->pay_type == 'bonus') {
            return \redirect()->route('visiosoft.module.bonus::bonus_pay');
        } else {
            return $this->bankOrder($request->pay_type, $order_id);
        }
    }

    public function getCart()
    {
        return $this->dispatch(new GetCart());
    }

    /**
     * Update all items in a cart.
     *
     * @param SaleitemRepositoryInterface $items
     * @param AdvRepositoryInterface $advRepository
     * @return array
     */
    public function update(SaleitemRepositoryInterface $items, AdvRepositoryInterface $advRepository)
    {
        $current_item = array();
        $id = $this->request->get('id');
        $quantity = $this->request->get('quantity');
        $type = $this->request->get('type');
        $item = $items->find($id);
        $cart = $this->dispatch(new GetCart());

        if ($type == "remove") {
            if ($item->entry_type == "Visiosoft\PackagesModule\Package\PackageModel") {
                event(new PackageCartRemoved($item));
            }

            $cart->remove($id); //Remove item in cart
            $current_item['cart'] = $this->getCart();

            if (\request()->currency) {
                $defCurr = setting_value('streams::currency');
                $current_item['cart']->total = $this->currency->format($current_item['cart']->total, $defCurr);
                $current_item['cart']->subtotal = $this->currency->format($current_item['cart']->subtotal, $defCurr);
            }

            $current_item['msg'] = "success";
            return $current_item;
        }
        //Get Quantity for Type
        $quantity = $items->getQuantity($quantity, $type, $item);

        if ($item) {
            if ($item->entry_type == "Visiosoft\AdvsModule\Adv\AdvModel") {
                //Get Adv in Cart
                $adv = $advRepository->findById($item->getAttribute('entry_id'));

                if ($adv->stock >= $quantity) {
                    $cart->remove($id); //Remove item in cart
                    $cart->add($adv, $quantity); //Add new item in cart
                    $current_item['cartItem'] = $this->dispatch(new GetCart())->items->last(); //Get last item in Cart
                    $current_item['adv'] = $adv;
                    $current_item['cart'] = $this->getCart();
                    $current_item['msg'] = "success";
                } else {
                    $current_item['adv'] = $adv;
                    $current_item['msg'] = "error1"; //No Limit
                    if ($adv->stock == 0) {
                        $current_item['msgContent'] = trans('visiosoft.module.carts::message.error1in1'); //No Limit
                    } else {
                        $current_item['msgContent'] = trans('visiosoft.module.carts::message.error1in2'); //No Limit
                    }
                }
            } else {
                $current_item['msg'] = "error2"; //No Ads
                $current_item['msgContent'] = trans('visiosoft.module.carts::message.error2'); //No Ads
            }
        } else {
            $current_item['msg'] = "error3"; //No Cart İtem
            $current_item['msgContent'] = trans('visiosoft.module.carts::message.error3'); //No Cart İtem
        }

        return $current_item;
    }
}
