function getInput(field) {
    var row = field.parent().parent();
    return $(row).find('input[name="quantity"]');
}

//plus
$('.quantity-plus-btn').on('click', function () {
    var input = getInput($(this));
    updatePrice(input, 'plus')
})

//minus
$('.quantity-minus-btn').on('click', function () {
    var input = getInput($(this));
    updatePrice(input, 'minus')
})

//change
$('input[name="quantity"]').on('change', function () {
    updatePrice(this, 'change')
})

$('select[name="configuration"]').on('change', function () {
    quantity_input = $(this).closest('form').find('input[name="quantity"]');
    quantity_input.attr('data-id', $(this).val()).val(1)
    $('.prices .ad-price').html($('select[name="configuration"] option:selected').attr('data-price'))
    $('.item-stock').html($('select[name="configuration"] option:selected').attr('data-stock'))
    $('.footer-mobile-device .ad-price b').html($('.footer-mobile-device select[name="configuration"] option:selected').attr('data-price'))

    updatePrice(quantity_input.get(0), 'change')
});

function updatePrice(input, type) {
    var ad_id = $(input).attr('data-id');
    var dataType = $(input).attr('data-type');
    var current_quantity = $(input).val();

    productDetail(ad_id, current_quantity, type, dataType, function (data) {
        ChangeFieldForResponse(type, data.newPrice, data.newQuantity, data.maxQuantity, data.minQuantity)
    });

}

function productDetail(id, quantity, type, dataType, returnData) {
    if (quantity == 0) {
        quantity = 1;
    }
    $.ajax({
        type: 'POST',
        url: '/ajax/StockControl',
        data: 'id=' + id + '&quantity=' + quantity + '&type=' + type + '&dataType=' + dataType,
        success: function (data) {
            returnData(data);
        }
    });
}

function ChangeFieldForResponse(type, price, quantity, maxQuantity, minQuantity = 0) {
    if (parseInt(quantity) == 1 || parseInt(quantity) == minQuantity ) {
        $('.quantity-minus-btn').attr('disabled', true);
    } else {
        $('.quantity-minus-btn').attr('disabled', false);
    }
    if (quantity == maxQuantity) {
        $('.quantity-plus-btn').attr('disabled', true);
    } else {
        $('.quantity-plus-btn').attr('disabled', false);
    }
    $('input[name="quantity"]').val(parseInt(quantity));
    $('.total-price').html(`<p>${price}</p>`);
}

$('.add-cart-button').on('click', function () {
    let quantity = $('input[name="quantity"]').val();
    let id = $('input[name="quantity"]').attr('data-id');
    let name = $('select[name="option"]').val();
    let isButtonType = $(this).data('type')
    name = name ? name : null;
    return addCart(id, quantity, name, isButtonType)
})

$('.conf-add-cart-button').on('click', function () {
    let quantity = $('input[name="quantity"]').val();
    let id = $('input[name="quantity"]').attr('data-id');
    let configuration = $('select[name="configuration"]').val();

    crudAjax({'quantity': quantity, 'id': id, 'configuration': configuration}, '/api/conf/add-cart', 'POST', function (callback) {
        if (callback.status === 'success') {
            window.location.href = "/cart/review";
        }
    })
});

function addCart(id, quantity, name = null, isButtonType = null) {
    let data = 'id=' + id + '&quantity=' + quantity;
    data = name ? data + '&name=' + name : data;
    $.ajax({
        type: 'POST',
        url: '/ajax/addCart',
        data: data,
        success: function (data) {
            if (data.status == "success") {
                if (typeof isButtonType !== "undefined" && isButtonType === 'checkout') {
                    window.location.href = "/cart/review";
                } else {
                    Toast.fire(data.msg, 'success');
                }
            } else {
                alert(data.msg);
            }
        }
    });
}

//Update Price for Configuration
$('select[name="configuration"]').trigger('change');
