<?php namespace Visiosoft\CartsModule\Modifier\Command;

use Visiosoft\CartsModule\Modifier\Contract\ModifierInterface;
use Visiosoft\CartsModule\Modifier\ModifierValue;

/**
 * Class CalculateValue
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class CalculateValue
{

    /**
     * The modifier instance.
     *
     * @var ModifierInterface
     */
    protected $modifier;

    /**
     * The value to apply
     * the modifier to.
     *
     * @var float
     */
    protected $value;

    /**
     * Create a new CalculateValue instance.
     *
     * @param ModifierInterface $modifier
     * @param float $value
     */
    public function __construct(ModifierInterface $modifier, $value)
    {
        $this->value    = $value;
        $this->modifier = $modifier;
    }

    /**
     * Handle the command.
     *
     * @param ModifierValue $value
     * @return float
     */
    public function handle(ModifierValue $value)
    {
        $modification = $this->modifier->getValue();

        $delta = $value->clean($modification);

        if ($value->isPercentage($modification)) {
            $delta = floatval($this->value * ($delta / 100));
        }

        return $delta;
    }
}
