<?php namespace Visiosoft\CartsModule\Cart;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;

class CartCriteria extends EntryCriteria
{

    public function getCookieCart()
    {
        $cart = array();
        if(isset($_COOKIE['cart']))
        {
            $AdvModel = new AdvModel();
            $total = 0;
            $i = 0;
            foreach ($_COOKIE['cart'] as $adv =>  $quantity)
            {
                $ad = $AdvModel->isAdv($adv);
                $total = number_format($total + $ad->price, 2);
                $cart[$i]['entry_type'] = 'Visiosoft\AdvsModule\Adv\AdvModel';
                $cart[$i]['quantity'] = $quantity;
                $cart[$i]['detail_url'] = $AdvModel->getAdvDetailLinkByAdId($ad->id);
                $cart[$i]['cover_photo'] = $AdvModel->GetAdsDefaultCoverImageByAdId($ad->id);
                $cart[$i]['price'] = $ad->price;
                $cart[$i]['name'] = $ad->name;
                $cart[$i]['entry_id'] = $ad->id;
                $cart[$i]['total'] = $total;
                $cart[$i]['subtotal'] = $ad->price;
                $cart[$i]['currency'] = $ad->currency;
                $i++;
            }
        }
        return $cart;
    }

    public function getCart()
    {
        $advModel = new AdvModel();

        $cart = $this->dispatch(new GetCart());
        foreach ($cart->items as $index => $ad) {
            foreach ($cart->items as $index => $ad) {
                if ($ad->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                    $cart->items[$index]->detail_url = $advModel->getAdvDetailLinkByAdId($ad->entry_id);
                    $cart->items[$index]->cover_photo = $advModel->GetAdsDefaultCoverImageByAdId($ad->entry_id);
                } else {
                    $cart->items[$index]->cover_photo = $this->dispatch(new MakeImageInstance('theme::images/no-image-ads.jpg', 'img'))->url();
                    $cart->items[$index]->detail_url = "#";
                }
            }
        }
        return $cart;
    }
}
