$("#cart-address").submit(function (e) {
    e.preventDefault(); // avoid to execute the actual submit of the form.
    var form = $(this);
    var url = form.attr('action');

    $.ajax({
        type: "POST",
        url: url,
        data: form.serialize(), // serializes the form's elements.
        success: function (data) {
            if (data.status == "success") {
                $('select[name="delivery_address"]').find('option:selected').removeAttr('selected');
                $('select[name="bill_address"]').find('option:selected').removeAttr('selected');
                var option = '<option value="' + data.data.id + '" selected>' + data.data.adress_name + '</option>';
                $('select[name="delivery_address"]').append(option);
                $('select[name="bill_address"]').append(option);
                $('#addAddress').modal('hide');
            } else {
                alert(data.msg)
            }
        }
    });
});
$(document).ready(function () {
    var ckbox = $('.same-address input');

    ckbox.on('click', function () {
        if (ckbox.is(':checked')) {
            $('.bill_address').css({'opacity': '0.5', 'filter': 'alpha(opacity=50)'});
            $('.bill_address').find('select').attr('disabled', true)
        } else {
            $('.bill_address').css({'opacity': '1', 'filter': 'none'});
            $('.bill_address').find('select').attr('disabled', false)
        }
    });

        $('select[name="delivery_address"]').on('change', function () {
            if (ckbox.is(':checked')) {

                $('select[name="bill_address"]').val($(this).val())
            }
        })

});
