function getInputForMobile(id) {
    return $('tr[data-id="' + id + '"]').find('.mobile-input');
}

function getInput(id) {
    return $('tr[data-id="' + id + '"]').find('.web-input');
}

function getProductRow(id) {
    return $('tr[data-id="' + id + '"]');
}

/*Change*/
$('input[data-name="web-change"]').on('change', function () {
    var input = getInput($(this).attr('data-id'));
    updateQuantity(input, 'change',$(this).attr('data-id'));
})

$('input[data-name="mobile-change"]').on('change', function () {
    var input = getInputForMobile($(this).attr('data-id'));
    updateQuantity(input, 'change',$(this).attr('data-id'));
})


$('button[data-name="web-plus"]').on('click',function () {
    var input = getInput($(this).attr('data-id'));
    updateQuantity(input, 'plus',$(this).attr('data-id'));
})

$('button[data-name="mobile-plus"]').on('click',function () {
    var input = getInputForMobile($(this).attr('data-id'));
    updateQuantity(input, 'plus',$(this).attr('data-id'));
})

$('button[data-name="web-minus"]').on('click',function () {
    var input = getInput($(this).attr('data-id'));

    updateQuantity(input, 'minus',$(this).attr('data-id'));
})

$('button[data-name="mobile-minus"]').on('click',function () {
    var input = getInputForMobile($(this).attr('data-id'));
    updateQuantity(input, 'minus',$(this).attr('data-id'));
})

function changeDataID(id,Row) {
    $(Row).attr('data-id', id);

    $(Row).find('button[data-name="web-minus"]').attr('data-id',id)
    $(Row).find('button[data-name="mobile-minus"]').attr('data-id',id)

    $(Row).find('button[data-name="web-plus"]').attr('data-id',id)
    $(Row).find('button[data-name="mobile-plus"]').attr('data-id',id)

    $(Row).find('input[data-name="web-change"]').attr('data-id',id)
    $(Row).find('input[data-name="mobile-change"]').attr('data-id',id)

    $(Row).find('div[data-name="mobile-remove"]').attr('data-id',id)
    $(Row).find('button[data-name="web-remove"]').attr('data-id',id)
}


$('button[data-name="web-remove"], div[data-name="mobile-remove"]').click(function () {
    var row = getProductRow($(this).attr('data-id'))
    removeRow(row);
});



/* Update quantity */
function updateQuantity(quantityInput, type, id) {
    /* Calculate line price */
    var productRow = getProductRow(id)
    var cartId = id;
    var quantity = quantityInput.val();

    if (parseInt(quantity) == 0 || quantity == "") {
        var res = confirm(confirmMessage);
        if (res == true) {
            removeItem(cartId)
            productRow.remove();
        } else {
            productDetail(cartId, 1, type, function (data) {
                if (data.msg == "success") {
                    Responsesuccess(data, quantityInput, productRow)
                }
            });
        }
    } else {
        productDetail(cartId, quantity, type, function (data) {

            if (data.msg == "success") {
                Responsesuccess(data, quantityInput, productRow)
            } else if (data.msg == "error1") {
                //uyarıyı bas ve maksimum adeti kaydet
                alert(data.msgContent);//stok mesajını bas
                if (data.adv.stock == 0) {
                    productRow.remove();
                    removeItem(cartId)

                } else {
                    productDetail(cartId, data.adv.stock, type, function (data) {

                        if (data.msg == "success") {
                            Responsesuccess(data, quantityInput, productRow)
                        }
                    });
                }
            } else {
                alert(data.msgContent)
                productRow.remove();
                removeItem(cartId)
            }
        });
    }
}

function Responsesuccess(data, quantityInput, productRow) {
    quantityInput.val(data.cartItem.quantity);
    if (parseInt(data.cartItem.quantity) == 1) {
        $(productRow).find('button[data-type="minus"]').attr('disabled', true);
    } else if (parseInt(data.cartItem.quantity) > 1) {
        $(productRow).find('button[data-type="minus"]').attr('disabled', false);
    }
    $(productRow).find('.cart-item-price').html(data.cartItem.subtotal);
    $(productRow).find('.product-line-price').html(data.cartItem.subtotal);
    changeDataID(data.cartItem.id,productRow)
    $('.total-price h3 b').html(data.cart.subtotal);
}


/* Remove item from cart */
function removeRow(row) {
    var productRow = row;
    var cartId = parseInt($(productRow).attr('data-id'));
    /* Remove row from DOM and recalc cart total */
    productRow.fadeOut(500, function () {
        productRow.remove();
        removeItem(cartId)
    });
}

function removeItem(cartId) {
    productDetail(cartId, 0, 'remove', function (data) {
        if (data.msg == "success") {
            if (parseInt(data.cart.subtotal) == 0) {
                location.reload();
            }
            $('.total-price h3 b').html(data.cart.subtotal);
        }
    });
}

function productDetail(id, quantity, type, returnData) {
    $.ajax({
        type: 'POST',
        url: '/cart/quantity',
        data: 'id=' + id + '&quantity=' + quantity + '&type=' + type,
        success: function (data) {
            hideLoader()
            returnData(data);
        },
        beforeSend: function () {
            showLoader()
        }
    });
}