//Phone Field
phoneMask("input[name='phone']");

//Address Area

getCountries()
    .then(function () {
        return getCities($('select[name="country"]').val());
    });

function getCountries() {
    return crudAjax('', '/ajax/getCountry', 'GET', function (callback) {
        $('select[name="country"]').html("<option>...</option>");
        $.each(callback, function (index, value) {
            var selected = (value.abv.toLowerCase() == app_locale) ? 'selected' : '';
            $('select[name="country"]').append("<option " + selected + " value='" + value.id + "'>" + value.name + "</option>");
        });
    }, true)
}

function getCities(country) {
    const selectsInput = $('select[name=city], select[name=district]')
    selectsInput.prop('disabled', true)

    $('select[name="district"]').html("<option value=''>...</option>");

    return crudAjax(`id=${country}`, '/ajax/getCities', 'POST', () => {
    }, true)
        .then(function (cities) {
            $('select[name="city"]').html("<option value=''>...</option>");
            $.each(cities, function (index, value) {
                $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectsInput.prop('disabled', false)
        })
}

function getDistricts(city) {
    const selectDistrictInput = $('select[name=district]');
    selectDistrictInput.prop('disabled', true)

    return crudAjax(`id=${city}`, '/ajax/getDistricts', 'POST', () => {
    }, true)
        .then(function (districts) {
            $('select[name="district"]').html("<option value=''>...</option>");
            $.each(districts, function (index, value) {
                $('select[name="district"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectDistrictInput.prop('disabled', false)
        })
}

$('select[name="country"]').on('change', function () {
    getCities($(this).val());
});

$('select[name="city"]').on('change', function () {
    getDistricts($(this).val());
});

$('#contractBtn').on('click', () => {
    let cart = $('input[name="cart"]').val(),
        page = $('input[name="refund_page"]').val(),
        email = $('input[name="email"]').val(),
        first_name = $('input[name="first_name"]').val(),
        last_name = $('input[name="last_name"]').val(),
        phone = $('input[name="phone"]').val(),
        address = $('textarea[name="address"]').val(),
        country = $('select[name="country"] option:selected').text(),
        city = $('select[name="city"] option:selected').text(),
        district = $('select[name="district"] option:selected').text(),
        pay_type = 'iyzico',
        payment_address = address + ' ' + district + ' ' + city + ' ' + country;

    crudAjax({
        'cart': cart,
        'page': page,
        'email': email,
        'first_name': first_name,
        'last_name': last_name,
        'phone': phone,
        'payment_address': payment_address,
        'pay_type': pay_type,
    }, `/contract-page`, 'GET', (callback) => {
        $('#contractModal .modal-body').html('');
    }).then((callback) => {
        $.each(callback ,function (key, value) {
            $('#contractModal .modal-body').append(
                `<div class="accordion" id="accordionExample">
                  <div class="card">
                    <div class="card-header" id="headingOne">
                      <h2 class="mb-0">
                        <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#${key}" aria-expanded="true" aria-controls="${key}">
                          ${value.store_name}
                        </button>
                      </h2>
                    </div>
                    <div id="${key}" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample">
                      <div class="card-body">
                        ${value.content}
                      </div>
                    </div>
                  </div>
                </div>`
            )
        })
    })
})