<?php namespace Visiosoft\CartsModule\Saleitem\Command;

use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;

/**
 * Class RemoveItem
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class RemoveSaleitem
{

    /**
     * The cart instance.
     *
     * @var CartInterface
     */
    protected $cart;

    /**
     * The item ID.
     *
     * @var int
     */
    protected $item;

    /**
     * Create a new RemoveItem instance.
     *
     * @param CartInterface $cart
     * @param $id
     */
    public function __construct(CartInterface $cart, $id)
    {
        $this->cart = $cart;
        $this->id   = $id;
    }

    /**
     * Handle the command.
     *
     * @param ItemRepositoryInterface $items
     */
    public function handle(SaleitemRepositoryInterface $items)
    {
        $items->delete(
            $this->cart
                ->getItems()
                ->find($this->id)
        );
    }
}
