<?php namespace Visiosoft\CartsModule\Console;

use Illuminate\Console\Command;
use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Visiosoft\CartsModule\Cart\Event\CartAbandoned;

class CartReminder extends Command
{
    protected $name = 'carts:reminder';

    public function handle(CartRepositoryInterface $cartRepository)
    {
        $recentAbandonedCarts = $cartRepository->getRecentAbandonedCarts();

        foreach ($recentAbandonedCarts as $cart) {
            if ($cart->user && count($cart->items)) {
                event(new CartAbandoned($cart->user, route('visiosoft.module.carts::cart')));
            }
        }
    }
}
