<?php namespace Visiosoft\CartsModule\Cart;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;

class CartCriteria extends EntryCriteria
{

    public function getCart()
    {
        $advModel = new AdvModel();

        $cart = $this->dispatch(new GetCart());
        foreach ($cart->items as $index => $ad) {
            foreach ($cart->items as $index => $ad) {
                if ($ad->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                    $cart->items[$index]->detail_url = $advModel->getAdvDetailLinkByAdId($ad->entry_id);
                    $cart->items[$index]->cover_photo = $advModel->GetAdsDefaultCoverImageByAdId($ad->entry_id);
                } else {
                    $cart->items[$index]->cover_photo = $this->dispatch(new MakeImageInstance('theme::images/no-image.png', 'img'))->url();
                    $cart->items[$index]->detail_url = "#";
                }
            }
        }
        return $cart;
    }
}
