<?php namespace Visiosoft\CartsModule\Saleitem\Command;

use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;

/**
 * Class TotalItem
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class TotalSaleitem
{

    /**
     * The item instance.
     *
     * @var ItemInterface
     */
    protected $item;

    /**
     * Create a new TotalItem instance.
     *
     * @param ItemInterface $item
     */
    public function __construct(SaleitemInterface $item)
    {
        $this->item = $item;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        $this->item->load('modifiers');

        $tax = setting_value('visiosoft.module.orders::tax');


        $this->item->setAttribute(
            'subtotal',
            $this->item->getQuantity() * $this->item->getPrice()
        );

        //calculate TAX
        $tax = ($this->item->getSubtotal() * $tax) / 100;


        $this->item->setAttribute('tax', $tax);
        $this->item->setAttribute('shipping', $this->item->calculate('shipping'));
        $this->item->setAttribute('discounts', $this->item->calculate('discount'));
        $this->item->setAttribute(
            'total',
            $this->item->getSubtotal()
            - $this->item->getDiscounts()
            + $this->item->getShipping()
            + $this->item->getTax()
        );
    }
}
