<?php namespace Visiosoft\CartsModule;

use Visiosoft\CartsModule\Cart\CustomerInformationForm\CustomerInformationFormBuilder;
use Visiosoft\CartsModule\Console\CartReminder;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Visiosoft\CartsModule\Saleitem\SaleitemRepository;
use Anomaly\Streams\Platform\Model\Carts\CartsSaleitemsEntryModel;
use Visiosoft\CartsModule\Saleitem\SaleitemModel;
use Visiosoft\CartsModule\Saleitem\SaleitemProcessor;
use Visiosoft\CartsModule\Saleitem\Listener\ProcessSaleitems;
use Visiosoft\CartsModule\Cart\CartModel;
use Visiosoft\CartsModule\Cart\CartProcessor;
use Visiosoft\CartsModule\Cart\CartRepository;
use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Visiosoft\CartsModule\Cart\Listener\AddUserToCart;
use Visiosoft\CartsModule\Cart\Listener\ProcessCart;
use Visiosoft\CartsModule\Modifier\Contract\ModifierRepositoryInterface;
use Visiosoft\CartsModule\Modifier\ModifierModel;
use Visiosoft\CartsModule\Modifier\ModifierRepository;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Carts\CartsCartsEntryModel;
use Anomaly\Streams\Platform\Model\Carts\CartsModifiersEntryModel;
use Anomaly\UsersModule\User\Event\UserWasLoggedIn;
use Illuminate\Contracts\Config\Repository;

class CartsModuleServiceProvider extends AddonServiceProvider
{
    protected $commands = [
        CartReminder::class,
    ];

    protected $plugins = [
        CartsModulePlugin::class,
    ];

    protected $routes = [
        'admin/carts/view-cart-items/{id}' => 'Visiosoft\CartsModule\Http\Controller\Admin\CartsController@viewCartItems',
        'admin/carts/notify-abandoned-cart/{id}' => 'Visiosoft\CartsModule\Http\Controller\Admin\CartsController@notifyAbandonedCart',
        'admin/carts/saleitems'           => 'Visiosoft\CartsModule\Http\Controller\Admin\SaleitemsController@index',
        'admin/carts/saleitems/create'    => 'Visiosoft\CartsModule\Http\Controller\Admin\SaleitemsController@create',
        'admin/carts/saleitems/edit/{id}' => 'Visiosoft\CartsModule\Http\Controller\Admin\SaleitemsController@edit',
        'admin/carts/ads'           => 'Visiosoft\CartsModule\Http\Controller\Admin\AdsController@index',
        'admin/carts/ads/create'    => 'Visiosoft\CartsModule\Http\Controller\Admin\AdsController@create',
        'admin/carts/ads/edit/{id}' => 'Visiosoft\CartsModule\Http\Controller\Admin\AdsController@edit',
        'admin/carts/items'           => 'Visiosoft\CartsModule\Http\Controller\Admin\temsController@index',
        'admin/carts/items/create'    => 'Visiosoft\CartsModule\Http\Controller\Admin\ItemsController@create',
        'admin/carts/items/edit/{id}' => 'Visiosoft\CartsModule\Http\Controller\Admin\ItemsController@edit',
        'cart'                    => [
            'as'   => 'visiosoft.module.carts::cart',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@view',
        ],
        'carts/{instance}'        => [
            'as'   => 'visiosoft.module.carts::carts.view',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@view',
        ],
        'cart/review'        => [
            'middleware' => 'auth',
            'as'   => 'visiosoft.module.carts::carts.review',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@review_cart',
        ],
        'carts/{instance}/pay' => [
            'as'   => 'visiosoft.module.carts::carts.update',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@pay',
        ],
        'carts/items/remove/{id}' => [
            'as'   => 'visiosoft.module.carts::items.remove',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\SaleitemsController@remove',
        ],
        'cart/bankorder' => [
            'middleware' => 'auth',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@bankOrder',
        ],
        'payment/fail/{type?}' => [
            'as' => 'visiosoft.module.carts::payment_failed',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@fail'
        ],
        'payment/success/{type}' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.carts::payment_success',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@success'
        ],
        'cart/quantity' => 'Visiosoft\CartsModule\Http\Controller\CartsController@update',

        'customer/information' => [
            'as' => 'visiosoft.module.carts::auth_costumer',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CustomerController@authCustomer',
        ],
        'customer/billing-information' => 'Visiosoft\CartsModule\Http\Controller\CustomerController@billingInformation',
        'customer/billing-company-fields' => 'Visiosoft\CartsModule\Http\Controller\CustomerController@billingCompanyFields',

        'customer/payment' => [
            'as' => 'visiosoft.module.carts::checkout_costumer',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@checkoutCustomer',
        ],

	    'contract-page' => 'Visiosoft\CartsModule\Http\Controller\CartsController@getContractPage',

                // Ajax Routes
        'ajax/add-cart' => [
            'as' => 'visiosoft.module.carts::ajax.add_cart',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\AjaxController@addCart'
        ],
        'ajax/update-cart' => [
            'as' => 'visiosoft.module.carts::ajax.update_cart',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\AjaxController@updateCart'
        ],
        'ajax/remove-cart' => [
            'as' => 'visiosoft.module.carts::ajax.remove_cart',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\AjaxController@removeCart'
        ],

        'carts/pay/respond' => [
            'as' => 'visiosoft.module.carts::respond',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@payRespond',
        ],
    ];

    protected $listeners = [
        UserWasLoggedIn::class => [
            AddUserToCart::class,
            ProcessSaleitems::class,
            ProcessCart::class,
        ],
    ];

    protected $bindings = [
        CartsSaleitemsEntryModel::class => SaleitemModel::class,
        CartsModifiersEntryModel::class => ModifierModel::class,
        CartsCartsEntryModel::class => CartModel::class,
    ];

    protected $schedules = [
        'daily' => [
            CartReminder::class,
        ],
    ];

    protected $singletons = [
        'customer-information' => CustomerInformationFormBuilder::class,
        SaleitemRepositoryInterface::class => SaleitemRepository::class,
        CartProcessor::class               => CartProcessor::class,
        SaleitemProcessor::class               => SaleitemProcessor::class,
        CartRepositoryInterface::class     => CartRepository::class,
        ModifierRepositoryInterface::class => ModifierRepository::class,
    ];

    public function register(CartProcessor $carts, SaleitemProcessor $items, Repository $config)
    {
        $items->setProcessors($config->get($this->addon->getNamespace('processors.items'), []));
        $carts->setProcessors($config->get($this->addon->getNamespace('processors.carts'), []));
    }
}
