<?php namespace Visiosoft\CartsModule\Cart\Traits;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CouponModule\Coupon\Command\calculateTotalWithCouponCode;

trait calculateTotal
{
    use DispatchesJobs;

    public function calculateTotal()
    {
        $cart = $this->dispatch(new GetCart());

        if ($couponCode = request()->cookie('coupon_code')) {
            $discount = $this->dispatch(new calculateTotalWithCouponCode($couponCode));
        } else {
            $discount = $this->dispatch(new \Visiosoft\CouponModule\Coupon\Command\calculateTotal($couponCode));
        }

        $total = $cart->total - $discount;

        return ['total' => $total < 0 ? 0 : $total, 'discount' => $discount, 'couponCode' => $couponCode];
    }
}
