<?php namespace Visiosoft\CartsModule\Cart\CustomerInformationForm;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class CustomerInformationFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'first_name' => [
            'label' => 'visiosoft.module.carts::field.first_name.name',
            'type' => 'anomaly.field_type.text',
            'required' => true
        ],
        'last_name' => [
            'label' => 'visiosoft.module.carts::field.last_name.name',
            'type' => 'anomaly.field_type.text',
            'required' => true
        ],
        'email' => [
            'label' => 'visiosoft.module.carts::field.email.name',
            'type' => 'anomaly.field_type.email',
            'required' => true
        ],
        'phone' => [
            'label' => 'visiosoft.module.carts::field.phone.name',
            'type' => 'anomaly.field_type.text',
            'required' => true
        ],
        'country' => [
            'label' => 'visiosoft.module.carts::field.country.name',
            'type' => 'anomaly.field_type.select',
            'required' => true
        ],
        'city' => [
            'label' => 'visiosoft.module.carts::field.city.name',
            'type' => 'anomaly.field_type.select',
            'required' => true
        ],
        'district' => [
            'label' => 'visiosoft.module.carts::field.district.name',
            'type' => 'anomaly.field_type.select',
            'required' => true
        ],
        'address' => [
            'label' => 'visiosoft.module.carts::field.address.name',
            'type' => 'anomaly.field_type.textarea',
            'required' => true
        ],
        'address_name' => [
            'label' => 'visiosoft.module.carts::field.address_name.name',
            'type' => 'anomaly.field_type.text',
            'required' => true
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
