<?php namespace Visiosoft\CartsModule\Cart\Command;

use Visiosoft\CartsModule\Cart\CartInstance;
use Illuminate\Session\Store;

/**
 * Class DestroyCart
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Cart\Command
 */
class DestroyCart
{

    /**
     * The cart instance.
     *
     * @var string
     */
    protected $instance;

    /**
     * Create a new DestroyCart instance.
     *
     * @param $instance
     */
    public function __construct($instance = null)
    {
        $this->instance = $instance;
    }

    /**
     * Handle the command.
     *
     * @param Store $session
     */
    public function handle(CartInstance $instance)
    {
        $instance->destroy($this->instance);
    }
}
