<?php namespace Visiosoft\CargoIntegrationModule\Http\Controller;


use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Teknomavi\Kargo\CargoFactory;
use Teknomavi\Kargo\Company\ServiceInterface;
use Teknomavi\Kargo\Exception\InvalidProvider;
use Visiosoft\CargoIntegrationModule\CargoInfo\Contract\CargoInfoRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;
use Teknomavi\Kargo\Model\Package;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;
use Visiosoft\LocationModule\Country\Contract\CountryRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;


class CargoController extends ResourceController
{
    /**
     * The entry model.
     *
     * @var ServiceInterface
     */
    public $CargoProvider;
    public $CargoRepository;
    public $orderdetailRepository;
    public $adressRepository;
    public $districtRepository;

    public function __construct(
        OrderdetailRepositoryInterface $orderdetailRepository,
        AdressRepositoryInterface $adressRepository,
        DistrictRepositoryInterface $districtRepository,
        CargoInfoRepositoryInterface $CargoRepository
    )
    {
        parent::__construct();
        $this->orderdetailRepository = $orderdetailRepository;
        $this->adressRepository = $adressRepository;
        $this->districtRepository = $districtRepository;
        $this->CargoRepository = $CargoRepository;

    }

    /**
     * @param string $cargo_slug
     *
     * @return ServiceInterface
     * @throws InvalidProvider
     *
     */
    public function Cargo_Init($Cargo): ServiceInterface
    {
        if ($Cargo) {
            $company = $Cargo->getAttributeValue('company');
            $username = $Cargo->getAttributeValue('username');
            $password = $Cargo->getAttributeValue('password');
            if ($company == 'Surat') {
                $options = [
                    'KullaniciAdi' => $username,
                    'Sifre' => $password,
                ];
            } else {
                $options = [
                    'username' => $username,
                    'password' => $password,
                ];
            }
            $this->CargoProvider = CargoFactory::initServiceProvider($company, $options);
            return $this->CargoProvider;
        } else {

            throw new InvalidProvider(trans('visiosoft.module.cargo_integration::message.cargo_info_not_found', ['name' => $Cargo->getAttributeValue('name')]));

        }

    }

    public function Cargo_TestGetPackageInfoByReferenceNumber($cargoKey)
    {
        return $this->CargoProvider->getPackageInfoByReferenceNumber($cargoKey);
    }

    public function Cargo_TestGetShipmentStatusByReferenceNumber($cargoKey)
    {
        return $this->CargoProvider->getShipmentStatusByReferenceNumber($cargoKey);
    }

    public function Cargo_TestGetShipmentStatusByReferenceNumberList($keyList)
    {
        return $this->CargoProvider->getShipmentStatusByReferenceNumberList($keyList);
    }

    public function Cargo_TestCreateShipment()
    {
        $package = new Package();
        $package->setPaymentType(Package::PAYMENT_TYPE_SHIPPER_PAY);
        $package->setNumberOfPackages(1); // Daha sonra toplu da denenecek
        $package->setConsigneeName('ABC Sirketi Muhendislik AS');
        $package->setConsigneeTown('KADIKOY');
        $package->setConsigneeCity('ISTANBUL');
        $package->setConsigneeAddress('TEST SOKAGI TEST CADDESI');
        $package->setConsigneeEmail('testUser@gtest.com');
        $package->setConsigneeCountry('Turkey');
        $package->setConsigneeMobilPhone('05555555555');
        $package->setConsigneePostalCode('76543');
        $package->setInvoiceNo('TESTTES');
        $package->setReferenceNo('9999XXXaaXY'); // cargo Key I suppose
        $package->setPackageType(Package::PACKAGE_TYPE_BOX);
        $package->setShipmentType(Package::SHIPMENT_TYPE_PREPAID);
        $this->CargoProvider->addPackage($package);


        $package2 = new Package();
        $package2->setPaymentType(Package::PAYMENT_TYPE_SHIPPER_PAY);
        $package2->setNumberOfPackages(1); // Daha sonra toplu da denenecek
        $package2->setConsigneeName('TEST Muhendislik Musavirlik AS');
        $package2->setConsigneeTown('CANKAYA');
        $package2->setConsigneeCity('ANKARA');
        $package2->setConsigneeAddress('TEST CADDESI TEST SOKAGI');
        $package2->setConsigneeEmail('testCONSIGNEE@gmail.com');
        $package2->setConsigneeCountry('Turkey');
        $package2->setConsigneeMobilPhone('05555555555');
        $package2->setConsigneePostalCode('76543');
        $package2->setInvoiceNo('TESTTES');
        $package2->setReferenceNo('9999XadfXXXXX'); // cargo Key I suppose
        $package2->setPackageType(Package::PACKAGE_TYPE_BOX);
        $package2->setShipmentType(Package::SHIPMENT_TYPE_PREPAID);
        $this->CargoProvider->addPackage($package2);
        return $this->CargoProvider->sendPackages();
    }

    public function handlePaymentOrder(\Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder $event)
    {
        //Check Event
        if (!$event->user or !$event->order or !setting_value('visiosoft.module.cargo_integration::selected_cargo')) {
            throw new \Exception(trans('visiosoft.module.cargo_integration::message.user_order_not_found'));
        }

        $user = $event->user;
        $order = $event->order;
        $cargo_company = $this->CargoRepository->find(setting_value('visiosoft.module.cargo_integration::selected_cargo'));

        //Get Order details
        $ordersDetails = $this->orderdetailRepository->newQuery()->where('order_id', $order->id)->get();

        //Check Address
        if (!$address = $this->adressRepository->find($order->delivery_address_id)) {
            throw new \Exception(trans('visiosoft.module.cargo_integration::message.address_not_found'));
        }

        //Set Address Detail
        $addressData['address'] = $address->adress_name . ' / ' . $address->adress_content;
        $addressData['state'] = ($district = $this->districtRepository->find($address->district)) ? $district->name : '-';
        $addressData['city'] = ($city = $address->getCity()) ? $city->name : '-';
        $addressData['country'] = ($country = $address->getCountry()) ? $country->name : '-';

        //Start Cargo
        $this->Cargo_Init($cargo_company);

        // [2 => Kapıda ödeme nakit,1 => Ön ödemeli]
        $ShipmentList = [
            'order' => 2,
            'paypal' => 1,
            'stripe' => 1,
            'iyzico' => 1,
            'balance' => 1
        ];

        if (!empty($user->gsm_phone)) {
            $MobilePhone = $user->gsm_phone;
        } else {
            if (!empty($user->land_phone)) {
                $MobilePhone = $user->land_phone;
            } else {
                if (!empty($user->office_phone)) {
                    $MobilePhone = $user->office_phone;
                } else {
                    $MobilePhone = '';
                }
            }
        }

        $PaymentType = '';//yok | kargo ödemesi gönderici mi alıcımı ödeyecektir.
        $PostalCode = '';//yok | posta kodu
        $PackageType = '';//yok |

        foreach ($ordersDetails as $key => $ordersDetail) {
            $package = new Package();
            $package->setPaymentType($PaymentType);
            $package->setConsigneeName($user->name());
            $package->setConsigneeTown($addressData['state']);
            $package->setConsigneeCity($addressData['city']);
            $package->setConsigneeAddress($addressData['address']);
            $package->setConsigneeEmail($user->email);
            $package->setConsigneeCountry($addressData['country']);
            $package->setConsigneeMobilPhone($MobilePhone);
            $package->setConsigneePostalCode($PostalCode);
            $package->setPackageType($PackageType);
            $package->setInvoiceNo($order->id);
            $package->setNumberOfPackages($key + 1);
            $package->setReferenceNo(intval($order->id."00000".$ordersDetail->item_id));
            $package->setShipmentType($ShipmentList[$order->pay_type]);
            $this->CargoProvider->addPackage($package);
        }
        $shipping = $this->CargoProvider->sendPackages();

        if (!$shipping[intval($order->id."00000".$ordersDetail->item_id)]->isSuccess()) {
            $this->messages->error([$shipping[intval($order->id."00000".$ordersDetail->item_id)]->getErrorDescription()]);
            $this->messages->error(trans('visiosoft.module.cargo_integration::message.auto_cargo_error'));
        }
    }

}
//CargoController::Cargo_TestCreateShipment();
//CargoController::Cargo_TestGetShipmentStatusByReferenceNumber("9999XadfXXXXX");
//CargoController::Cargo_TestGetPackageInfoByReferenceNumber("9999XXXXXX");
//CargoController::Cargo_TestGetShipmentStatusByReferenceNumberList(["9999XadfXXXXX", "9999XXXXXX"]);
