<?php namespace Visiosoft\CargoIntegrationModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CargoIntegrationModule\CargoInfo\Contract\CargoInfoRepositoryInterface;
use Visiosoft\CargoIntegrationModule\CargoInfo\CargoInfoRepository;
use Anomaly\Streams\Platform\Model\CargoIntegration\CargoIntegrationCargoInfoEntryModel;
use Visiosoft\CargoIntegrationModule\CargoInfo\CargoInfoModel;
use Visiosoft\OrdersModule\Orderdetail\Event\PaymentOrder;

class CargoIntegrationModuleServiceProvider extends AddonServiceProvider
{


    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/cargo_integration' => [
            'as' => 'visiosoft.module.cargo_integration::cargo_api.import',
            'uses' => 'Visiosoft\CargoIntegrationModule\Http\Controller\Admin\CargoInfoController@index'],
        'admin/cargo_integration/create' => [
            'as' => 'visiosoft.module.cargo_integration::cargo_api.create',
            'uses' => 'Visiosoft\CargoIntegrationModule\Http\Controller\Admin\CargoInfoController@create'],
        'admin/cargo_integration/edit/{id}' => [
            'as' => 'visiosoft.module.cargo_integration::cargo_api.edit',
            'uses' => 'Visiosoft\CargoIntegrationModule\Http\Controller\Admin\CargoInfoController@edit'],
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        PaymentOrder::class => [
            \Visiosoft\CargoIntegrationModule\CargoInfo\CargoInfoListener::class,
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        CargoIntegrationCargoInfoEntryModel::class => CargoInfoModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CargoInfoRepositoryInterface::class => CargoInfoRepository::class,
    ];

    public function boot(AddonCollection $addonCollection)
    {
        $settings_url = [
            'settings' => [
                'title' => 'visiosoft.module.cargo_integration::button.settings',
                'href' => '/admin/settings/modules/visiosoft.module.cargo_integration',
                'page' => 'visiosoft.module.cargo_integration'
            ],
        ];

        foreach ($settings_url as $key => $value) {
            $addonCollection->get($value['page'])->addSection($key, $value);
        }
    }

}
