<?php namespace Visiosoft\CargoIntegrationModule\Http\Controller;


use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Teknomavi\Kargo\Company\ServiceInterface;
use Visiosoft\CargoIntegrationModule\CargoInfo\Contract\CargoInfoRepositoryInterface;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;


class CargoController extends ResourceController
{
    /**
     * The entry model.
     *
     * @var ServiceInterface
     */
    public $CargoProvider;
    public $CargoRepository;
    public $addressRepository;
    public $districtRepository;

    public function __construct(
        AdressRepositoryInterface $addressRepository,
        DistrictRepositoryInterface $districtRepository,
        CargoInfoRepositoryInterface $CargoRepository
    )
    {
        parent::__construct();
        $this->addressRepository = $addressRepository;
        $this->districtRepository = $districtRepository;
        $this->CargoRepository = $CargoRepository;

    }

    /**
     * @throws \Exception
     */
    public function handlePaymentOrder(OrderApproved $event)
    {
        //Check Event
        if (!$event->getOrder() || !$event->getOrder()->user || !setting_value('visiosoft.module.cargo_integration::selected_cargo')) {
            throw new \Exception(trans('visiosoft.module.cargo_integration::message.user_order_not_found'));
        }

        $order = $event->getOrder();
        $cargo_company = $this->CargoRepository->find(setting_value('visiosoft.module.cargo_integration::selected_cargo'));

        if (!$cargo_company) {
            return $this->messages->error(trans('visiosoft.module.cargo_integration::message.cargo_company_not_found'));
        }

        $company_name = $cargo_company->getAttributeValue('company');

        //Check Address
        if (!$address = $this->addressRepository->find($order->delivery_address_id)) {
            throw new \Exception(trans('visiosoft.module.cargo_integration::message.address_not_found'));
        }

        //Set Address Detail
        $addressData['address'] = $address->adress_name . ' / ' . $address->adress_content;
        $addressData['state'] = ($district = $this->districtRepository->find($address->district)) ? $district->name : '-';
        $addressData['city'] = ($city = $address->getCity()) ? $city->name : '-';
        $addressData['country'] = ($country = $address->getCountry()) ? $country->name : '-';

        //Start Cargo
        $provider = 'Visiosoft\\CargoIntegrationModule\\Command\\' . $company_name . '\\Service';
        if (!class_exists($provider)) {
            $this->messages->error(trans('visiosoft.module.cargo_integration::message.auto_cargo_error'));
        }

        $cargo = app($provider);

        $this->CargoProvider = $cargo->initService();

        // [2 => Kapıda ödeme nakit,1 => Ön ödemeli]
        $ShipmentList = [
            'order' => 2,
            'pay_at_door' => 2,
            'paypal' => 1,
            'stripe' => 1,
            'iyzico' => 1,
            'balance' => 1
        ];

        $item_count = 0;
        foreach ($event->getOrderDetail() as $key => $ordersDetail) {
            if (in_array($ordersDetail->item_type, ['adv', 'ads-configuration'])) {

                if (!is_module_installed('visiosoft.module.store')) {
                    return $this->messages->error(trans('visiosoft.module.cargo_integration::message.store_module_not_installed'));
                }

                if (!$store = app(StoreRepositoryInterface::class)->findByUser($ordersDetail->seller->id)) {
                    return $this->messages->error(trans('visiosoft.module.cargo_integration::message.store_module_not_installed'));
                }
                ++$item_count;
                $this->CargoProvider->addPackage($cargo->setPackage($order, $ordersDetail, $addressData, $item_count, $ShipmentList, $store));
            }
        }
        $shipping = $this->CargoProvider->sendPackages();
        $cargo->setDetail($shipping, $cargo_company);
    }
}
