<?php namespace Visiosoft\CargoIntegrationModule\Command\Ups;

use Anomaly\Streams\Platform\Message\MessageBag;
use Teknomavi\Kargo\Model\Package;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CargoIntegrationModule\CargoInfo\Contract\CargoInfoRepositoryInterface;
use Visiosoft\CargoIntegrationModule\Command\Cargo;
use Visiosoft\CargoIntegrationModule\Shipment\Contract\ShipmentRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;


class Service
{
    protected $shipperAccountNumber;
    protected $cargoInfoRepository;
    protected $advRepository;
    protected $orderDetailRepository;
    protected $shipmentRepository;
    protected $messages;

    public function __construct(
        CargoInfoRepositoryInterface   $cargoInfoRepository,
        AdvRepositoryInterface         $advRepository,
        OrderdetailRepositoryInterface $orderDetailRepository,
        ShipmentRepositoryInterface    $shipmentRepository,
        MessageBag                     $messages
    )
    {
        $this->cargoInfoRepository = $cargoInfoRepository;
        $this->advRepository = $advRepository;
        $this->orderDetailRepository = $orderDetailRepository;
        $this->shipmentRepository = $shipmentRepository;
        $this->messages = $messages;
    }

    /**
     * @throws \Teknomavi\Kargo\Exception\InvalidProvider
     */
    public function initService()
    {
        $cargo_company = $this->cargoInfoRepository->find(setting_value('visiosoft.module.cargo_integration::selected_cargo'));
        if ($cargo_company) {
            $username = $cargo_company->getAttributeValue('username');
            $password = $cargo_company->getAttributeValue('password');
            $this->shipperAccountNumber = $cargo_company->getAttributeValue('referance_no');

            $options = [
                'customerCode' => $this->shipperAccountNumber,
                'username' => $username,
                'password' => $password,
            ];

            $initCargo = new Cargo();
            return $initCargo->initCargo($cargo_company, $options);
        }
    }

    public function setPackage($order, $ordersDetail, $addressData, $item_count, $ShipmentList, $seller): Package
    {
        $PaymentType = '';//yok | kargo ödemesi gönderici mi alıcımı ödeyecektir.
        $PostalCode = '';//yok | posta kodu
        $PackageType = 2;

        $user = $order->user;
        $MobilePhone = $user->gsm_phone ?? ($user->land_phone ?? ($user->office_phone ?? ''));

        $package = new Package();
        $package->setPaymentType($PaymentType);
        $package->setConsigneeName($user->name());
        $package->setConsigneeTown($addressData['state']);
        $package->setConsigneeCity($addressData['city']);
        $package->setConsigneeAddress($addressData['address']);
        $package->setConsigneeEmail($user->email);
        $package->setConsigneeCountry($addressData['country']);
        $package->setConsigneeMobilPhone($MobilePhone);
        $package->setConsigneePostalCode($PostalCode);
        $package->setPackageType($PackageType);
        $package->setInvoiceNo($order->id);
        $package->setNumberOfPackages($item_count);
        $package->setReferenceNo((int)($order->id . "00000" . $ordersDetail->id));
        $package->setShipmentType($ShipmentList[$order->pay_type]);
        $package->setShipperName($seller->name);
        $package->setShipperAddress($seller->address);
        $package->setShipperCity($seller->getCity()->name);
        $package->setShipperTown($seller->getDistrict()->name);
        $package->setShipperAccountNumber($this->shipperAccountNumber);
        return $package;
    }

    public function setDetail($shipping, $cargo_company)
    {
        foreach ($shipping as $shipping_key => $shipping_detail) {
            if (!$shipping[(int)$shipping_key]->isSuccess()) {
                $this->messages->error([$shipping_detail->getErrorDescription()]);
                $this->messages->error(trans('visiosoft.module.cargo_integration::message.auto_cargo_error'));
            } else {
                $shipping_detail_key = explode('00000', $shipping_key);
                $item_id = end($shipping_detail_key);
                $tracking_number = $shipping_detail->getTrackingNumber();
                if ($order_detail = $this->orderDetailRepository->find($item_id)) {
                    $detail_url = 'https://www.ups.com.tr/WaybillSorgu.aspx?Waybill=' . $tracking_number;

                    $order_detail->setAttribute('transport_detail_url', $detail_url);
                    $order_detail->setAttribute('tracking_number', $tracking_number);
                    $order_detail->setAttribute('transport_days', 5);
                    $order_detail->setAttribute('status', 'awaiting_payment_approval');
                    $order_detail->save();

                    $this->messages->success(trans('visiosoft.module.cargo_integration::message.created_cargo_message', ['code' => $tracking_number, 'company' => $cargo_company->name]));

                    //Save Record
                    try {
                        $this->shipmentRepository->createShipment($item_id, $cargo_company->getId(), json_encode(['detail_url' => $detail_url, 'tracking_number' => $tracking_number]));
                    } catch (\Exception $exception) {
                        $this->messages->error([$exception->getMessage()]);
                    }
                }
            }
        }
    }
}
