<?php namespace Visiosoft\CargoIntegrationModule\Command\Surat;

use Anomaly\Streams\Platform\Message\MessageBag;
use Teknomavi\Kargo\Model\Package;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CargoIntegrationModule\CargoInfo\Contract\CargoInfoRepositoryInterface;
use Visiosoft\CargoIntegrationModule\Shipment\Contract\ShipmentRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;

class Service
{
    protected $shipperAccountNumber;
    protected $cargoInfoRepository;
    protected $advRepository;
    protected $orderDetailRepository;
    protected $shipmentRepository;
    protected $messages;

    public function __construct(
        CargoInfoRepositoryInterface   $cargoInfoRepository,
        AdvRepositoryInterface         $advRepository,
        OrderdetailRepositoryInterface $orderDetailRepository,
        ShipmentRepositoryInterface    $shipmentRepository,
        MessageBag                     $messages
    )
    {
        $this->cargoInfoRepository = $cargoInfoRepository;
        $this->advRepository = $advRepository;
        $this->orderDetailRepository = $orderDetailRepository;
        $this->shipmentRepository = $shipmentRepository;
        $this->messages = $messages;

    }

    public function setPackage($order, $ordersDetail, $addressData, $item_count, $ShipmentList): Package
    {
        $PaymentType = '';//yok | kargo ödemesi gönderici mi alıcımı ödeyecektir.
        $PostalCode = '';//yok | posta kodu
        $PackageType = '';//yok |

        $user = $order->user;
        $MobilePhone = $user->gsm_phone ?? ($user->land_phone ?? ($user->office_phone ?? ''));

        $package = new Package();
        $package->setPaymentType($PaymentType);
        $package->setConsigneeName($user->name());
        $package->setConsigneeTown($addressData['state']);
        $package->setConsigneeCity($addressData['city']);
        $package->setConsigneeAddress($addressData['address']);
        $package->setConsigneeEmail($user->email);
        $package->setConsigneeCountry($addressData['country']);
        $package->setConsigneeMobilPhone($MobilePhone);
        $package->setConsigneePostalCode($PostalCode);
        $package->setPackageType($PackageType);
        $package->setInvoiceNo($order->id);
        $package->setNumberOfPackages($item_count);
        $package->setReferenceNo((int)($order->id . "00000" . $ordersDetail->id));
        $package->setShipmentType($ShipmentList[$order->pay_type]);
        return $package;
    }

    public function setDetail($shipping, $cargo_company)
    {
        foreach ($shipping as $shipping_key => $shipping_detail) {
            if (!$shipping[(int)$shipping_key]->isSuccess()) {
                $this->messages->error([$shipping_detail->getErrorDescription()]);
                $this->messages->error(trans('visiosoft.module.cargo_integration::message.auto_cargo_error'));
            } else {
                $shipping_detail_key = explode('00000', $shipping_key);
                $item_id = end($shipping_detail_key);
                if ($order_detail = $this->orderDetailRepository->find($item_id)) {

                    $detail_url = 'https://www.suratkargo.com.tr/KargoTakip/?kargotakipno=' . $shipping_key;
                    $order_detail->setAttribute('transport_detail_url', $detail_url);
                    $order_detail->setAttribute('tracking_number', $shipping_key);
                    $order_detail->setAttribute('transport_days', 5);
                    $order_detail->setAttribute('status', 'awaiting_payment_approval');
                    $order_detail->save();

                    $this->messages->success(trans('visiosoft.module.cargo_integration::message.created_cargo_message', ['code' => $shipping_key, 'company' => $cargo_company->name]));

                    //Save Record
                    try {
                        $this->shipmentRepository->createShipment($item_id, $cargo_company->getId(), json_encode(['detail_url' => $detail_url, 'tracking_number' => $shipping_key]));
                    } catch (\Exception $exception) {
                        $this->messages->error([$exception->getMessage()]);
                    }
                }
            }
        }

    }
}
