<?php namespace Visiosoft\CargoIntegrationModule\Command;

use Teknomavi\Kargo\CargoFactory;
use Teknomavi\Kargo\Exception\InvalidProvider;

class Cargo
{
    /**
     * @throws InvalidProvider
     */
    public function initCargo($cargo, $options = null): \Teknomavi\Kargo\Company\ServiceInterface
    {
        if ($cargo) {
            $company = $cargo->getAttributeValue('company');
            return CargoFactory::initServiceProvider($company, $options);
        }

        throw new InvalidProvider(trans('visiosoft.module.cargo_integration::message.cargo_info_not_found', ['name' => $cargo->getAttributeValue('name')]));
    }
}
