<?php namespace Visiosoft\CargoIntegrationModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\CargoIntegration\CargoIntegrationShipmentEntryModel;
use Visiosoft\CargoIntegrationModule\CargoInfo\Contract\CargoInfoRepositoryInterface;
use Visiosoft\CargoIntegrationModule\CargoInfo\CargoInfoRepository;
use Anomaly\Streams\Platform\Model\CargoIntegration\CargoIntegrationCargoInfoEntryModel;
use Visiosoft\CargoIntegrationModule\CargoInfo\CargoInfoModel;
use Visiosoft\CargoIntegrationModule\Shipment\Contract\ShipmentRepositoryInterface;
use Visiosoft\CargoIntegrationModule\Shipment\ShipmentModel;
use Visiosoft\CargoIntegrationModule\Shipment\ShipmentRepository;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;

class CargoIntegrationModuleServiceProvider extends AddonServiceProvider
{


    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/cargo_integration' => [
            'as' => 'visiosoft.module.cargo_integration::cargo_api.import',
            'uses' => 'Visiosoft\CargoIntegrationModule\Http\Controller\Admin\CargoInfoController@index'],
        'admin/cargo_integration/create' => [
            'as' => 'visiosoft.module.cargo_integration::cargo_api.create',
            'uses' => 'Visiosoft\CargoIntegrationModule\Http\Controller\Admin\CargoInfoController@create'],
        'admin/cargo_integration/edit/{id}' => [
            'as' => 'visiosoft.module.cargo_integration::cargo_api.edit',
            'uses' => 'Visiosoft\CargoIntegrationModule\Http\Controller\Admin\CargoInfoController@edit'],
        'update-cargo-detail/{item_id}' => [
            'as' => 'visiosoft.module.cargo_integration::update_cargo_information',
            'uses' => 'Visiosoft\CargoIntegrationModule\Http\Controller\CargoController@updateTrackingDetailByItem'
        ],
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        OrderApproved::class => [
            \Visiosoft\CargoIntegrationModule\CargoInfo\CargoInfoListener::class,
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        CargoIntegrationCargoInfoEntryModel::class => CargoInfoModel::class,
        CargoIntegrationShipmentEntryModel::class => ShipmentModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CargoInfoRepositoryInterface::class => CargoInfoRepository::class,
        ShipmentRepositoryInterface::class => ShipmentRepository::class,
    ];

    public function boot(AddonCollection $addonCollection)
    {
        $settings_url = [
            'settings' => [
                'title' => 'visiosoft.module.cargo_integration::button.settings',
                'href' => '/admin/settings/modules/visiosoft.module.cargo_integration',
                'page' => 'visiosoft.module.cargo_integration'
            ],
        ];

        foreach ($settings_url as $key => $value) {
            $addonCollection->get($value['page'])->addSection($key, $value);
        }
    }

}
