<?php namespace Visiosoft\CargoIntegrationModule\CargoInfo;

use Anomaly\SelectFieldType\SelectFieldType;
use ReflectionClass;

class CargoInfoHandler
{
    public function handle(SelectFieldType $fieldType)
    {
        $reflection = new ReflectionClass('Teknomavi\Kargo\CargoFactory');
        $options = array();
        foreach ($reflection->getConstants() as $constant_key => $constant_value) {
            if (strstr($constant_key, 'PROVIDER_')) {
                $provider = 'Teknomavi\\Kargo\\Company\\' . $constant_value . '\\Service';
                if (class_exists($provider)) {
                    $options[$constant_value] = $constant_value;
                }

            }
        }
        $fieldType->setOptions($options);
    }
}
