<?php namespace Visiosoft\CargoIntegrationModule\Shipment;

use Visiosoft\CargoIntegrationModule\Shipment\Contract\ShipmentRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ShipmentRepository extends EntryRepository implements ShipmentRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ShipmentModel
     */
    protected $model;

    /**
     * Create a new ShipmentRepository instance.
     *
     * @param ShipmentModel $model
     */
    public function __construct(ShipmentModel $model)
    {
        $this->model = $model;
    }

    public function createShipment($order_item_id, $cargo_company_id, $response)
    {
        return $this->newQuery()->create([
            'order_item_id' => $order_item_id,
            'company' => $cargo_company_id,
            'response' => json_encode([
                'error_code' => $response->getErrorCode(),
                'error_description' => $response->getErrorDescription(),
                'tracking_number' => $response->getTrackingNumber(),
                'reference_number' => $response->getReferenceNumber(),
                'label_links' => $response->getLabelLinks(),
                'label_strings' => $response->getLabelStrings(),
                'success' => ($response->success) ? $response->success : null,
            ]),
        ]);
    }
}
