<?php namespace Visiosoft\CargoIntegrationModule\Http\Controller;


use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Teknomavi\Kargo\CargoFactory;
use Teknomavi\Kargo\Company\ServiceInterface;
use Teknomavi\Kargo\Exception\InvalidProvider;
use Visiosoft\CargoIntegrationModule\CargoInfo\Contract\CargoInfoRepositoryInterface;
use Visiosoft\CargoIntegrationModule\Shipment\Contract\ShipmentRepositoryInterface;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;
use Teknomavi\Kargo\Model\Package;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;
use Visiosoft\LocationModule\Country\Contract\CountryRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;


class CargoController extends ResourceController
{
    /**
     * The entry model.
     *
     * @var ServiceInterface
     */
    public $CargoProvider;
    public $CargoRepository;
    public $orderdetailRepository;
    public $adressRepository;
    public $districtRepository;
    public $shipmentRepository;

    public function __construct(
        OrderdetailRepositoryInterface $orderdetailRepository,
        AdressRepositoryInterface $adressRepository,
        DistrictRepositoryInterface $districtRepository,
        CargoInfoRepositoryInterface $CargoRepository,
        ShipmentRepositoryInterface $shipmentRepository
    )
    {
        parent::__construct();
        $this->orderdetailRepository = $orderdetailRepository;
        $this->adressRepository = $adressRepository;
        $this->districtRepository = $districtRepository;
        $this->CargoRepository = $CargoRepository;
        $this->shipmentRepository = $shipmentRepository;

    }

    public function Cargo_Init($Cargo, $options = null)
    {
        if ($Cargo) {
            $company = $Cargo->getAttributeValue('company');
            $username = $Cargo->getAttributeValue('username');
            $password = $Cargo->getAttributeValue('password');
            if ($company == 'Surat') {
                if (!$options) {
                    $options = [
                        'KullaniciAdi' => $username,
                        'Sifre' => $password,
                    ];
                }
            } else {
                if (!$options) {
                    $options = [
                        'username' => $username,
                        'password' => $password,
                    ];
                }
            }
            $this->CargoProvider = CargoFactory::initServiceProvider($company, $options);
            return $this->CargoProvider;
        } else {
            throw new InvalidProvider(trans('visiosoft.module.cargo_integration::message.cargo_info_not_found', ['name' => $Cargo->getAttributeValue('name')]));
        }

    }


    public function handlePaymentOrder(OrderApproved $event)
    {
        //Check Event
        if (!$event->getOrder() or !$event->getOrder()->user or !setting_value('visiosoft.module.cargo_integration::selected_cargo')) {
            throw new \Exception(trans('visiosoft.module.cargo_integration::message.user_order_not_found'));
        }

        $order = $event->getOrder();
        $user = $order->user;

        $cargo_company = $this->CargoRepository->find(setting_value('visiosoft.module.cargo_integration::selected_cargo'));

        //Check Address
        if (!$address = $this->adressRepository->find($order->delivery_address_id)) {
            throw new \Exception(trans('visiosoft.module.cargo_integration::message.address_not_found'));
        }

        //Set Address Detail
        $addressData['address'] = $address->adress_name . ' / ' . $address->adress_content;
        $addressData['state'] = ($district = $this->districtRepository->find($address->district)) ? $district->name : '-';
        $addressData['city'] = ($city = $address->getCity()) ? $city->name : '-';
        $addressData['country'] = ($country = $address->getCountry()) ? $country->name : '-';

        //Start Cargo
        $this->Cargo_Init($cargo_company);

        // [2 => Kapıda ödeme nakit,1 => Ön ödemeli]
        $ShipmentList = [
            'order' => 2,
            'paypal' => 1,
            'stripe' => 1,
            'iyzico' => 1,
            'balance' => 1
        ];

        if (!empty($user->gsm_phone)) {
            $MobilePhone = $user->gsm_phone;
        } else {
            if (!empty($user->land_phone)) {
                $MobilePhone = $user->land_phone;
            } else {
                if (!empty($user->office_phone)) {
                    $MobilePhone = $user->office_phone;
                } else {
                    $MobilePhone = '';
                }
            }
        }

        $PaymentType = '';//yok | kargo ödemesi gönderici mi alıcımı ödeyecektir.
        $PostalCode = '';//yok | posta kodu
        $PackageType = '';//yok |

        foreach ($event->getOrderDetail() as $key => $ordersDetail) {
            $package = new Package();
            $package->setPaymentType($PaymentType);
            $package->setConsigneeName($user->name());
            $package->setConsigneeTown($addressData['state']);
            $package->setConsigneeCity($addressData['city']);
            $package->setConsigneeAddress($addressData['address']);
            $package->setConsigneeEmail($user->email);
            $package->setConsigneeCountry($addressData['country']);
            $package->setConsigneeMobilPhone($MobilePhone);
            $package->setConsigneePostalCode($PostalCode);
            $package->setPackageType($PackageType);
            $package->setInvoiceNo($order->id);
            $package->setNumberOfPackages($key + 1);
            $package->setReferenceNo(intval($order->id . "00000" . $ordersDetail->id));
            $package->setShipmentType($ShipmentList[$order->pay_type]);
            $this->CargoProvider->addPackage($package);
        }
        $shipping = $this->CargoProvider->sendPackages();

        foreach ($shipping as $shipping_key => $shipping_detail) {
            if (!$shipping[intval($shipping_key)]->isSuccess()) {
                $this->messages->error([$shipping_detail->getErrorDescription()]);
                $this->messages->error(trans('visiosoft.module.cargo_integration::message.auto_cargo_error'));
            } else {
                $shipping_detail_key = explode('00000',$shipping_key);
                $item_id = end($shipping_detail_key);
                if ($order_detail = $this->orderdetailRepository->find($item_id)) {
                    $order_detail->setAttribute('transport_detail_url', 'https://www.suratkargo.com.tr/KargoTakip/?kargotakipno=' . $shipping_key);
                    $order_detail->setAttribute('tracking_number', $shipping_key);
                    $order_detail->setAttribute('transport_days', 5);
                    $order_detail->setAttribute('status', 'awaiting_payment_approval');
                    $order_detail->save();
                }
            }
        }
    }

    public function updateTrackingDetailByItem($item_id)
    {

        if ($order_detail = $this->orderdetailRepository->find($item_id)) {
            $detail_id = intval($order_detail->order_id . "00000" . $order_detail->id);

            //Check Event
            if (!setting_value('visiosoft.module.cargo_integration::selected_cargo')) {
                throw new \Exception(trans('visiosoft.module.cargo_integration::message.error_shipping_service'));
            }

            $cargo_company = $this->CargoRepository->find(setting_value('visiosoft.module.cargo_integration::selected_cargo'));

            $init = CargoFactory::initServiceProvider($cargo_company->getAttributeValue('company'), [
                'GonderenCariKodu' => $cargo_company->getAttributeValue('username'),
                'Sifre' => $cargo_company->getAttributeValue('webservice_password')
            ]);

            $detail = $init->getPackageInfoByReferenceNumber($detail_id);

            if ($detail->getErrorMessage()) {
                $this->messages->error($detail->getErrorMessage());
            } else {
                $order_detail->setAttribute('transport_detail_url', $detail->getTrackingURL());
                $order_detail->setAttribute('tracking_number', $detail->getTrackingNumber());
                $order_detail->setAttribute('transport_days', 5);
                $order_detail->setAttribute('status', 'awaiting_payment_approval');
                $order_detail->save();
            }
        } else {
            $this->messages->error(trans('visiosoft.module.cargo_integration::message.order_not_found'));
        }
        return $this->redirect->route('orders::sale_detail', ['id' => $order_detail->getId()]);
    }
}