<?php namespace Visiosoft\CargoIntegrationModule\Shipment;

use Visiosoft\CargoIntegrationModule\Shipment\Contract\ShipmentRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ShipmentRepository extends EntryRepository implements ShipmentRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ShipmentModel
     */
    protected $model;

    /**
     * Create a new ShipmentRepository instance.
     *
     * @param ShipmentModel $model
     */
    public function __construct(ShipmentModel $model)
    {
        $this->model = $model;
    }

    public function createShipment($order_item_id, $cargo_company_id, $response)
    {
        return $this->newQuery()->create([
            'order_item_id' => $order_item_id,
            'company' => $cargo_company_id,
            'response' => $response,
        ]);
    }
}
