<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCargoIntegrationCreateShipmentStream extends Migration
{
    protected $delete = false;

    protected $stream = [
        'slug' => 'shipment',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'order_item' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\OrdersModule\Orderdetail\OrderdetailModel::class,
            ]
        ],
        'company' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\CargoIntegrationModule\CargoInfo\CargoInfoModel::class,
            ]
        ],
        'response' => "visiosoft.field_type.json",
    ];

    protected $assignments = [
        'order_item',
        'company',
        'response',
    ];

}
