<?php namespace Visiosoft\CargoIntegrationModule\Http\Controller\Admin;


use Visiosoft\CargoIntegrationModule\CargoInfo\Form\CargoInfoFormBuilder;
use Visiosoft\CargoIntegrationModule\CargoInfo\Table\CargoInfoTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;


class CargoInfoController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param CargoInfoTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CargoInfoTableBuilder $table)
    {

        return $table->setColumns([
            'name', 'company', 'username', 'slug'
        ])->render();
    }

    /**
     * Create a new entry.
     *
     * @param CargoInfoFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CargoInfoFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CargoInfoFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CargoInfoFormBuilder $form, $id)
    {
        return $form->render($id);
    }

}
