<?php namespace Visiosoft\BotModule\Http\Controller;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\BotModule\Scrape\Contract\ScrapeRepositoryInterface;

class ScrapesController extends PublicController
{

    private $scrapeRepository;
    private $settingRepository;

    public function __construct(
        ScrapeRepositoryInterface $scrapeRepository,
        SettingRepositoryInterface $settingRepository
    )
    {
        set_time_limit(0);
        parent::__construct();
        $this->scrapeRepository = $scrapeRepository;
        $this->settingRepository = $settingRepository;
    }

    public function registerScrape($url, $urlType, $module)
    {
        $registeredPage = $this->scrapeRepository->findBy('url', $url);
        if (is_null($registeredPage)) {
            $this->scrapeRepository->create([
                'url' => $url,
                'url_type' => $urlType,
                'module' => $module
            ]);
        }

        return $registeredPage;
    }

    public function curl($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Accept: application/json"
        ));
        $response = curl_exec($ch);
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        return [
            'response' => $response,
            'statusCode' => $statusCode
        ];
    }

    public function scrapeRegisteredPages()
    {
        $unscrappedPages = $this->scrapeRepository
            ->newQuery()
            ->where('is_scrapped', 0)
            ->limit($this->settingRepository->value('visiosoft.bot.module::scrape_pages_at_once'))
            ->get();
        foreach ($unscrappedPages as $unscrappedPage) {
            $unscrappedPage->update(['is_scrapped' => -1]);
        }
        foreach ($unscrappedPages as $unscrappedPage) {
            $scrapedPage = $this->curl($unscrappedPage->url);
            if ($scrapedPage['statusCode'] === 200) {
                $unscrappedPage->update([
                    'response' => $scrapedPage['response'],
                    'status_code' => $scrapedPage['statusCode'],
                    'is_scrapped' => 1
                ]);
            } else {
                $unscrappedPage->update([
                    'response' => $scrapedPage['response'],
                    'status_code' => $scrapedPage['statusCode'],
                    'is_scrapped' => 0
                ]);
            }
        }
    }

    public function adProcessed($url)
    {
        $processedUrl = $this->scrapeRepository->findBy('url', $url)->update([
            'processed' => 1
        ]);

        return $processedUrl;
    }

    public function getScrappedPages($urlType, $module)
    {
        $pagesUrls = $this->scrapeRepository
            ->newQuery()
            ->where('url_type', $urlType)
            ->where('module', $module)
            ->where('is_scrapped', 1)
            ->where('processed', 0)
            ->where('status_code', 200)
            ->limit($this->settingRepository->value('visiosoft.bot.module::scrape_pages_at_once'))
            ->get();

        foreach ($pagesUrls as $pageUrl) {
            $pageUrl->update(['processed' => -1]);
        }

        return $pagesUrls;
    }
}
