<?php namespace Visiosoft\BotModule\Http\Controller\Admin;

use Visiosoft\BotModule\Scrape\Form\ScrapeFormBuilder;
use Visiosoft\BotModule\Scrape\Table\ScrapeTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ScrapesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param ScrapeTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ScrapeTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ScrapeFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ScrapeFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ScrapeFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ScrapeFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function cron()
    {
        return $this->view->make('visiosoft.module.bot::cron');
    }
}
