<?php namespace Visiosoft\BotModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\BotModule\Scrape\Contract\ScrapeRepositoryInterface;
use Visiosoft\BotModule\Scrape\ScrapeRepository;
use Anomaly\Streams\Platform\Model\Bot\BotScrapesEntryModel;
use Visiosoft\BotModule\Scrape\ScrapeModel;
use Illuminate\Routing\Router;

class BotModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/bot'           => 'Visiosoft\BotModule\Http\Controller\Admin\ScrapesController@index',
        'admin/bot/create'    => 'Visiosoft\BotModule\Http\Controller\Admin\ScrapesController@create',
        'admin/bot/edit/{id}' => 'Visiosoft\BotModule\Http\Controller\Admin\ScrapesController@edit',
        'admin/bot/cron'      => 'Visiosoft\BotModule\Http\Controller\Admin\ScrapesController@cron',


        'bot/add-link/{link}/{linkType}/{module}' => [
            'as' => 'visiosoft.module.bot::registerScrape',
            'uses' => 'Visiosoft\BotModule\Http\Controller\ScrapesController@registerScrape'
        ],
        'bot/scrape-pages' => [
            'as' => 'visiosoft.module.bot::scrapeRegisteredPages',
            'uses' => 'Visiosoft\BotModule\Http\Controller\ScrapesController@scrapeRegisteredPages'
        ],
        'bot/ad-processed/{url}' => [
            'as' => 'visiosoft.module.bot::adProcessed',
            'uses' => 'Visiosoft\BotModule\Http\Controller\ScrapesController@adProcessed'
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\BotModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\BotModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\BotModule\Event\ExampleEvent::class => [
        //    Visiosoft\BotModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\BotModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BotScrapesEntryModel::class => ScrapeModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ScrapeRepositoryInterface::class => ScrapeRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
