<?php namespace Visiosoft\BotModule\Scrape;

use Visiosoft\BotModule\Scrape\Contract\ScrapeRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ScrapeRepository extends EntryRepository implements ScrapeRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ScrapeModel
     */
    protected $model;

    /**
     * Create a new ScrapeRepository instance.
     *
     * @param ScrapeModel $model
     */
    public function __construct(ScrapeModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $module
     * @param null $isProcessed
     * @param null $limit
     * @return \Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection|mixed
     */
    public function getByModule($module, $isProcessed = null, $limit = null)
    {
        $query = $this->newQuery()
            ->where('module', $module);

        if (!is_null($isProcessed)) {
            $query = $query->where('processed', $isProcessed);
        }
        if (!is_null($limit)) {
            $query = $query->limit($limit);
        }
        return $query->get();
    }
}
