<?php namespace Visiosoft\BotModule\Http\Controller\Admin;

use Illuminate\Support\Facades\DB;
use Visiosoft\BotModule\Scrape\Contract\ScrapeRepositoryInterface;
use Visiosoft\BotModule\Scrape\Form\ScrapeFormBuilder;
use Visiosoft\BotModule\Scrape\Table\ScrapeTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ScrapesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param ScrapeTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ScrapeTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ScrapeFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ScrapeFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ScrapeFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ScrapeFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function summary(ScrapeTableBuilder $table, ScrapeRepositoryInterface $scrapeRepository) {
        $columns = ['module', 'is_scrapped', 'status_code', 'processed'];

        $rows = $scrapeRepository // Get entries
            ->newQuery()
            ->select(DB::raw('count(id) as count'), ...$columns)
            ->groupBy(...$columns)
            ->get();

        $table->setTableEntries($rows); // Set entries

        $table->setButtons([]); // Remove edit button
        $table->setActions([]); // Remove delete action

        $table->setColumns(array_merge($columns, [ // Set columns
            'count' => [
                'value' => function($entry) {
                    return $entry->count;
                }
            ]
        ]));

        return $table->render();
    }

    public function cron()
    {
        return $this->view->make('visiosoft.module.bot::cron');
    }
}
