<?php namespace Visiosoft\BookingModule\Booking\Events;

use Visiosoft\BookingModule\Booking\BookingModel;
use Visiosoft\BookingModule\Booking\BookingRepository;
use Visiosoft\BookingModule\Location\LocationModel;
use Visiosoft\BookingModule\Service\ServiceModel;

class CancellationBooking
{
    public $bookingId;

    /**
     * CancellationBooking constructor.
     * @param $bookingId
     */
    public function __construct($bookingId)
    {
        $this->bookingId = $bookingId;
    }

    public function detail()
    {
        $bookingModel = new BookingModel();
        $bookingRepository = new BookingRepository($bookingModel);
        $booking = $bookingRepository->findTrashed($this->bookingId);
        return $booking;
    }

    public function location()
    {
        $serviceModel = new ServiceModel();
        $locationModel = new LocationModel();

        $service = $serviceModel->getServices($this->detail()->services_select);
        $location = $locationModel->getLocations($service->location_id);
        return $location;
    }
}
