var start_date = null;
var end_date = null;
var refresh = true;
var refresh_time = 30000; // Millisecond
/***************************/
/***///      AJAX      ****/
/*************************/
function crudForBooking(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Edit Booking   ****/
/*************************/
function bookingModal(id) {
    crudForBooking('id=' + id, '/admin/booking/getDetail/' + id, 'GET', function (response) {
        var details = response; //Detail Booking

        //Get Location ALL Locations
        getLocations(function () {

            //Get Location ID With Service ID && Select Location
            getServiceLocation(details.services_select, function (response) {
                $('select[name="locations"]').val(response.location_id);
                //Get Services With Location ID && Select Service
                getServices(response.location_id, function (e) {
                    $('select[name="services_select"]').val(details.services_select);

                    //Get Staff With Service && Select Staff
                    getStaff(details.services_select, function (e) {
                        $('#payment_type > option:nth-child(3)').attr('disabled', false);
                        $('form[name="booking-modal-form"]').append('<input name="id" type="hidden" value="' + details.id + '">');
                        $('form[name="booking-modal-form"]').attr('data-type', 'edit');
                        $('select[name="staff"]').val(details.staff_id)
                        $('input[name="phone"]').val(details.phone);
                        $('input[name="email"]').val(details.email);
                        $('input[name="name"]').val(details.name);
                        $('input[name="total_price"]').val(details.total_price);
                        $('select[name="payment_type"]').val(details.payment_type);

                        var removeBtn = $('.removeBtn');
                        removeBtn.attr('href', '/admin/booking/ajax/delete/' + details.id)


                        $('.payment_status').removeClass('hidden').find('font').html(payment_status[details.payment_status]);
                        if (details.payment_status != "success") {
                            $('.approvePayment').removeClass('hidden').attr('data-id', details.id);
                        }
                        if (details.status == "pending") {
                            $('.approveBtn').removeClass("hidden");
                            $('.approveMessage').removeClass("hidden");
                            var approveBtn = $('.approveBtn');
                            approveBtn.attr('data-id', details.id)
                        } else {
                            $('.approveBtn').addClass("hidden");
                            $('.approveMessage').addClass("hidden");
                        }
                        enable_picker(details.booking_datetime_start, details.booking_datetime_end);

                        $('.booking-edit-ajax').prop('disabled', false).removeClass('disabled')
                    })

                })

            });

        });

    })
    openModal();

}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Locations  ****/
/*************************/
function getLocations(callback) {
    crudForBooking('', '/admin/booking/ajax/locations', 'GET', function (response) {
        $('select[name="locations"]').html('');
        $('select[name="locations"]').append('<option selected disabled>...</option>');
        $.each(response, function (index, value) {
            $('select[name="locations"]').append('<option value=' + value.id + '>' + value.name + '</option>');
        });
        return callback();
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Location   ****/
/***/// With Service  ****/
/************************/
function getServiceLocation(service_id, callback) {
    crudForBooking('', '/admin/booking/ajax/find-services/booking_services.id,' + service_id, 'GET',
        function (response) {
            return callback(response);
        })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Services   ****/
/*************************/
function getServices(location_id, callback) {
    crudForBooking('', '/admin/booking/ajax/services/' + location_id, 'GET', function (response) {
        $('select[name="services_select"]').html('');
        $('select[name="services_select"]').append('<option selected disabled>...</option>');
        $.each(response, function (index, value) {
            // if (index == 0) getStaff(value.id);
            $('select[name="services_select"]').append('<option value=' + value.id + '>' + value.name + '</option>');
        });
        $('.services_select-field').show();
        $('.staff-field').hide();
        return callback(response);
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Staff      ****/
/*************************/
function getStaff(service_id, callback) {
    crudForBooking('', '/admin/booking/ajax/staff/' + service_id, 'GET', function (response) {
        $('select[name="staff"]').html('');
        $('select[name="staff"]').append('<option selected disabled>...</option>');
        $.each(response, function (index, value) {
            $('select[name="staff"]').append('<option value=' + value.id + '>' + value.name + '</option>');
        });
        $('.staff-field').show();
        return callback(response);
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***/// On Change Start ****/
/**************************/
$('select[name="locations"]').on('change', function () {
    getServices($(this).val(), function () {
    })
})

$('select[name="services_select"]').on('change', function () {
    getStaff($(this).val(), function () {
    })
})
/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***/// Create Booking  ****/
/**************************/
function addBooking(date) {
    getLocations(function () {
        enable_picker(date, date);
        $('select[name="services_select"]').html("");
        $('.payment_status').addClass('hidden').find('font').html('');
        $('.approvePayment').addClass('hidden').attr('href', '#');
        $('select[name="staff"]').html("");
        $('input[name="phone"]').val("");
        $('input[name="email"]').val("");
        $('input[name="name"]').val("");
        $('input[name="total_price"]').val("");
        $('select[name="payment_type"]').val('');
        $('#payment_type > option:nth-child(3)').attr('disabled', true);
        openModal();
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Create DatePicker****/
/**************************/
function enable_picker(start, end) {
    var opt = {
        altInput: true,
        allowInput: false,
        locale: "en",
        altFormat: "j F, Y H:i",
        minuteIncrement: 1,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        enableTime: true,
        noCalendar: false
    };
    if (start_date != null) {
        start_date.setDate(start);
    } else {
        $('input[name="booking_datetime_start"]').val(start);
        start_date = $('input[name="booking_datetime_start"]').flatpickr(opt);
    }
    if (end_date != null) {
        end_date.setDate(end);
    } else {
        $('input[name="booking_datetime_end"]').val(end)
        end_date = $('input[name="booking_datetime_end"]').flatpickr(opt);
    }
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Modal Form Submit****/
/**************************/
$('form[name="booking-modal-form"]').on("submit", function (event) {
    event.preventDefault();
    saveBooking($(this).serialize(), $('form[name="booking-modal-form"]').attr('data-type'))
});

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///   Save Booking  ****/
/**************************/
function saveBooking(params, type) {
    crudForBooking(params, '/admin/booking/ajax/' + type, 'POST', function (response) {
        if (response.status == 'success') location.href = location.href;
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///   Open Modal    ****/
/**************************/
function openModal() {
    $('#bookingModal').modal('show');
    refresh = false
    console.log("Refresh Stop!")
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///  On Modal Close    ****/
/**************************/
$('#bookingModal').on('hidden.bs.modal', function (e) {
    $('.booking-edit-ajax').prop('disabled', true).addClass('disabled')
});

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Refresh Function ****/
/**************************/

window.setInterval(function () {
    $('#calendar').fullCalendar('refetchEvents');
}, refresh_time);

/***********************************************************************************************************/
/**********************************************************************************************************/

$(function () {
    $('.services_select-field').hide();
    $('.staff-field').hide();
    $('#calendar').fullCalendar({
        events: '/admin/bookingJSON',
        timezone: "local",
        defaultView: 'agendaDay',
        editable: true,
        selectable: true,
        eventLimit: true, // allow "more" link when too many events
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay'
        },

        allDaySlot: false,
        resources: '/admin/staffJSON',
        eventClick: function (event, element) {
            bookingModal(event.id);
        },
        dayClick: function (date, jsEvent, view, resource) {
            addBooking(moment(date._d).format('YYYY-MM-DD HH:mm'));
        }
    });

});


/***********************************************************************************************************/

/**********************************************************************************************************/


$('.approvePayment').on('click', function () {
    var id = $(this).data('id');
    crudForBooking('', '/admin/booking/ajax/approvePayment/' + id, 'GET', function (callback) {
        if (callback.status === true) {
            alert(approvedPaymentMsg);
            $('.payment_status').find('font').html(payment_status["success"]);
            $('.approvePayment').addClass('hidden');
        }
    });
});


$('.approveBtn').on('click', function () {
    var id = $(this).data('id');
    crudForBooking('', '/admin/booking/ajax/approve/' + id, 'GET', function (callback) {
        if (callback.status === true) {
            alert(approvedBooking);
            $('.approveBtn').addClass("hidden");
            $('.approveMessage').addClass("hidden");
        }
    });
});
