<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBookingCreateLocationsStream extends Migration
{

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'locations',
        'title_column' => 'name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => true,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'photo' => [
            'required' => true
        ],
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'description' => [
            'required' => true,
        ],
        'address' => [
            'required' => true,
        ],
        'phone' => [
            'required' => true,
        ],
        'mondayStart',
        'mondayEnd',
        'tuesdayStart',
        'tuesdayEnd',
        'wednesdayStart',
        'wednesdayEnd',
        'thursdayStart',
        'thursdayEnd',
        'fridayStart',
        'fridayEnd',
        'saturdayStart',
        'saturdayEnd',
        'sundayStart',
        'sundayEnd',
        'mondayStartNoon',
        'mondayEndNoon',
        'tuesdayStartNoon',
        'tuesdayEndNoon',
        'wednesdayStartNoon',
        'wednesdayEndNoon',
        'thursdayStartNoon',
        'thursdayEndNoon',
        'fridayStartNoon',
        'fridayEndNoon',
        'saturdayStartNoon',
        'saturdayEndNoon',
        'sundayStartNoon',
        'sundayEndNoon',
        'enabled'
    ];

}
