<?php namespace Visiosoft\BookingModule\Holiday;

use Carbon\Carbon;
use Visiosoft\BookingModule\Holiday\Contract\HolidayRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class HolidayRepository extends EntryRepository implements HolidayRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var HolidayModel
     */
    protected $model;

    /**
     * Create a new HolidayRepository instance.
     *
     * @param HolidayModel $model
     */
    public function __construct(HolidayModel $model)
    {
        $this->model = $model;
    }

    public function getHolidays()
    {
        return $this->newQuery()
            ->where('staff_id', null)
            ->get();
    }

    public function getLunchBreakByStaff($staff)
    {
        return $this->newQuery()
            ->where('staff_id', $staff)
            ->where('date', '>', Carbon::now())
            ->get();
    }
}
