<?php namespace Visiosoft\BookingModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Anomaly\UsersModule\User\UserModel;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Visiosoft\BookingModule\Booking\Event\paymentPaypal;
use Visiosoft\BookingModule\Booking\BookingModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\BookingModule\Booking\Events\ActivationBooking;
use Visiosoft\BookingModule\Booking\Events\CreateBooking;
use Visiosoft\BookingModule\Booking\Listener\PaymentItem;
use Visiosoft\BookingModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\BookingModule\Location\LocationModel;
use Visiosoft\BookingModule\Service\ServiceModel;
use Visiosoft\BookingModule\Staff\StaffModel;
use Illuminate\Contracts\Events\Dispatcher;
use Visiosoft\PaypalMdoule\Event\itemPaypal;
use Visiosoft\PaypalModule\Events\PaypalItems;
use Visiosoft\PaypalModule\Listener\paypal;


class ProfileController extends ResourceController
{
    private $booking_model;
    private $services_model;
    private $staff_model;
    private $location_model;
    private $event;
    private $user_model;
    private $users;

    /**
     * BookingController constructor.
     * @param Dispatcher $events
     * @param ServiceModel $serviceModel
     * @param StaffModel $staffModel
     * @param LocationModel $locationModel
     * @param BookingModel $bookingModel
     */
    public function __construct(
        Dispatcher $events,
        ServiceModel $serviceModel,
        StaffModel $staffModel,
        LocationModel $locationModel,
        BookingModel $bookingModel,
        UserModel $user_model,
        UserRepositoryInterface $users
    )
    {
        parent::__construct();
        $this->event = $events;
        $this->booking_model = $bookingModel;
        $this->services_model = $serviceModel;
        $this->staff_model = $staffModel;
        $this->location_model = $locationModel;
        $this->user_model = $user_model;
        $this->users = $users;
    }


    /**
     * @return \Illuminate\Contracts\View\View|mixed
     */
    public function index()
    {
        $user = Auth::user();
        $info = [
            'first_name' => $user->first_name,
            'last_name' => $user->last_name,
            'email' => $user->email,
            'username' => $user->username,
            'phone' => $user->phone_number,
        ];
        $reservations = $this->booking_model->newQuery()
            ->where('user_id', Auth::id())
            ->orderByDesc('booking_booking.id')
            ->limit(10)
            ->get();
        $this->template->set('meta_title', trans('visiosoft.module.booking::field.profile_title'));
        return $this->view->make('visiosoft.module.booking::profile', compact('reservations', 'info'));
    }

    public function update(Request $request)
    {
        //Check unique fields
        $user = Auth::user();
        $unique = array();
        if ($user->username != $request->username) {
            $unique[] = 'username';
        } elseif ($user->phone_number != $request->phone) {
            $unique[] = 'phone';
        }
        if (count($errors = $this->booking_model->uniqueFieldControl($request->toArray(), $unique)) != 0) {
            return redirect('/my-profile')->with('error', $errors);
        }

        //Update user info
        $user = Auth::user();
        $info = [
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'username' => $request->username,
            'phone_number' => $request->phone,
        ];
        $user->update($info);
        if ($request->change_password == 'on' && !empty($request->password)) {
            if ($request->password === $request->repeat_password) {
                $user->setAttribute('password', $request->password);
                $user->save();
            } else {
                return redirect('/my-profile')->with('error', [trans('visiosoft.module.booking::messages.password_match')]);
            }
        }
        return redirect('/my-profile')->with('success', [trans('visiosoft.module.booking::messages.update_profile')]);
    }

}
