<?php namespace Visiosoft\BookingModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\BookingModule\Booking\Contract\BookingRepositoryInterface;
use Visiosoft\BookingModule\Booking\BookingRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingBookingEntryModel;
use Visiosoft\BookingModule\Booking\BookingModel;
use Visiosoft\BookingModule\Booking\Listener\ActivateBooking;
use Visiosoft\BookingModule\Location\LocationPlugin;
use Visiosoft\BookingModule\Service\ServicePlugin;
use Visiosoft\BookingModule\Staff\Contract\StaffRepositoryInterface;
use Visiosoft\BookingModule\Staff\StaffPlugin;
use Visiosoft\BookingModule\Staff\StaffRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingStaffEntryModel;
use Visiosoft\BookingModule\Staff\StaffModel;
use Visiosoft\BookingModule\Service\Contract\ServiceRepositoryInterface;
use Visiosoft\BookingModule\Service\ServiceRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingServicesEntryModel;
use Visiosoft\BookingModule\Service\ServiceModel;
use Visiosoft\BookingModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\BookingModule\Location\LocationRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingLocationsEntryModel;
use Visiosoft\BookingModule\Location\LocationModel;
use Illuminate\Routing\Router;
use Visiosoft\PaypalModule\Events\StatusItem;

class BookingModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        StaffPlugin::class,
        ServicePlugin::class,
        LocationPlugin::class,
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'booking/completed' =>
            [
                'as' => 'booking::action',
                'uses' => 'Visiosoft\BookingModule\Http\Controller\BookingController@booking',
            ],
        'booking/activated' =>
            [
                'as' => 'booking::activated',
                'uses' => 'Visiosoft\BookingModule\Http\Controller\BookingController@activateBooking',
            ],
        'booking/detail/{id}' => 'Visiosoft\BookingModule\Http\Controller\BookingController@detail',
        'booking' => [
            'as' => 'booking::create',
            'uses' => 'Visiosoft\BookingModule\Http\Controller\BookingController@index',
        ],
        'my-reservations' => 'Visiosoft\BookingModule\Http\Controller\BookingController@showReservations',
        'srv/location' => 'Visiosoft\BookingModule\Http\Controller\BookingController@srvLocation',
        'srv/service' => 'Visiosoft\BookingModule\Http\Controller\BookingController@srvService',
        'srv/staff' => 'Visiosoft\BookingModule\Http\Controller\BookingController@srvStaff',
        'admin/booking/booking' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@index',
        'admin/booking/getDetail/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@getDetails',
        'admin/booking/booking/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@create',
        'admin/booking/booking/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@edit',
        'admin/booking/staff' => 'Visiosoft\BookingModule\Http\Controller\Admin\StaffController@index',
        'admin/booking/staff/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\StaffController@create',
        'admin/booking/staff/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\StaffController@edit',
        'admin/booking/services' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@index',
        'admin/booking/services/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@create',
        'admin/booking/services/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@edit',
        'admin/booking' => 'Visiosoft\BookingModule\Http\Controller\Admin\LocationsController@index',
        'admin/booking/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\LocationsController@create',
        'admin/booking/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\LocationsController@edit',
        //Ajax Services
        'admin/booking/ajax/locations' => 'Visiosoft\BookingModule\Http\Controller\Admin\LocationsController@getLocations',
        'admin/booking/ajax/services/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@getServices',
        'admin/booking/ajax/find-services/{column},{value}' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@findService',
        'admin/booking/ajax/staff/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\StaffController@getStaff',
        'admin/booking/ajax/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@createAjax',
        'admin/booking/ajax/edit' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@editAjax',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\BookingModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\BookingModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        StatusItem::class => [
            ActivateBooking::class,
        ]
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\BookingModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        BookingBookingEntryModel::class => BookingModel::class,
        BookingStaffEntryModel::class => StaffModel::class,
        BookingServicesEntryModel::class => ServiceModel::class,
        BookingLocationsEntryModel::class => LocationModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        BookingRepositoryInterface::class => BookingRepository::class,
        StaffRepositoryInterface::class => StaffRepository::class,
        ServiceRepositoryInterface::class => ServiceRepository::class,
        LocationRepositoryInterface::class => LocationRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

    public function getOverrides()
    {
        $request = app('Illuminate\Http\Request');
        $view = $request->get('view');

        if ($request->segment(2) === $this->addon->getSlug() && $view !== 'table' and $request->path() == "admin/booking/booking") {
            return [
                'streams::table/partials/header' => 'visiosoft.module.booking::admin/table/partials/header',
                'streams::table/partials/body' => 'visiosoft.module.booking::admin/table/partials/body',
                'streams::table/table' => 'visiosoft.module.booking::admin/table/table'
            ];
        }

        return parent::getOverrides();
    }

}
