var dateList = [];
var timeList = [];
var date = [];
var holidays = [];
var SelectedDate;
var ServiceTime = 20;
var BookingServiceTime = service_time;
var staffData = [];
var bookingData = [];

var current_date = new Date();
var now = moment(moment().format('YYYY-MM-DD ' + current_date.getHours() + ':mm'));
var days = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'];

$(document).ready(function () {

    // phoneMask("input[name='phone']")


    var allWells = $('.setup-content'),
        parameters = {};

    allWells.hide();

    $('.steps-container').on('click', 'div.setup-panel a, .selected-options div', function (e) {
        e.preventDefault();

        const item = $(this)

        let target;
        if (item.prop('tagName') === 'A') {
            target = $(item.attr('href'));
        } else {
            target = $(`#step-${item.index() + 1}`);
        }

        item.parent().addClass('active-step').nextAll().removeClass('active-step');
        item.parent().prevAll().addClass('active-step');

        allWells.hide();
        target.show();
    });

    $(document).on('click', '.instant-next', function () {
        var curStep = $(this).closest(".setup-content"),
            curStepBtn = curStep.attr("id"),
            skipStep = null,
            nextStepWizard = $('div.setup-panel ul a[href="#' + curStepBtn + '"]').parent().next().children("a"),
            curInputs = curStep.find("input[type='text'],input[type='url'],input[type='radio']"),
            isValid = true;

        $(".form-group").removeClass("has-error");

        for (var i = 0; i < curInputs.length; i++) {
            if (!curInputs[i].validity.valid) {
                isValid = false;
                $(curInputs[i]).closest(".form-group").addClass("has-error");
            }
        }

        if (curStep.attr('id') === 'step-1') {
            $('.site-description').hide()
        }

        var btn = $(this).closest(".panel-body").children("input"),
            ItemType = btn.attr('name'),
            CheckedItem = $("input[name='" + ItemType + "_input']:checked"),
            Value = CheckedItem.val();

        var ItemText = CheckedItem.parent().find('p').text();

        parameters[ItemType] = Value;

        if (btn.hasClass('send')) {
            if (isValid) renderData(ItemType, Value, true);
        }

        if (btn.hasClass('getBooking')) {
            if (isValid) renderData(ItemType, JSON.stringify(parameters), true);
        }

        if (isValid) {
            if (ItemType == "service") {
                selectedService(Value, function (callback) {
                    skipStep = callback;
                })
            }
            $('input[name="' + ItemType + '_id"]').val(Value);
            createBreadCrumb(ItemText, curStepBtn);
            if (skipStep != null) {
                nextStepWizard = $('div.setup-panel ul a[href="#' + curStepBtn + '"]').parent().next().next().children("a");
            }
            nextStepWizard.removeAttr('disabled').trigger('click');
        }
    });

    function locationsRedirect(curStep, body_content, id) {
        curStep = $(curStep);
        var curStepBtn = curStep.attr("id"),
            nextStepWizard = $('div.setup-panel ul a[href="#' + curStepBtn + '"]').parent().next().children("a"),
            isValid = true;

        $(".form-group").removeClass("has-error");

        var btn = $(body_content).children("input"),
            ItemType = btn.attr('name'),
            CheckedItem = $(`input[value='${id}']`),
            Value = CheckedItem.val(),
            ItemText = CheckedItem.parent().find('label').text();

        parameters[ItemType] = Value;

        if (btn.hasClass('send')) {
            if (isValid) renderData(ItemType, Value, false);
        }

        $('input[name="' + ItemType + '_id"]').val(Value);
        createBreadCrumb(ItemText, curStepBtn);
        nextStepWizard.removeAttr('disabled').trigger('click');
    }

    if (locationId) {
        locationsRedirect('#step-1', '.body_location', locationId);
    }

    $('div.setup-panel li.active-step a').trigger('click');
});

function createBreadCrumb(value, step) {
    const selectedOptions = $('.selected-options');
    selectedOptions.show();
    if ($(".breadcrumb-" + step).length === 0) {
        selectedOptions.html(selectedOptions.html() + `
            <div class="booking-breadcrumb-active breadcrumb-${step}" data-step="${step}">
                <i class="fa fa-check" aria-hidden="true"></i>
                <p>${value}</p>
            </div>
        `);
    } else {
        $(".breadcrumb-" + step + " p").html(value);
    }
}

function createInput(id, name, type, photo = "", description = '') {
    return `
        <label for="${type}${id}" class="${type}-options">
            <div style="background-image: url('${photo}')"></div>
            <div>
                <input class="instant-next" type="radio" id="${type}${id}" name="${type}_input" required
                    value="${id}" />
                <p>${name}</p>
                <small class="text-muted font-weight-normal">${description ?? ''}</small>
            </div>
        </label>
    `
}

function renderData(name, val, async) {
    sendData(name, val, async, function (response) {
        if (response.type != undefined) {
            responseInput(response);
        } else {
            dateList = [];
            timeList = [];
            date = [];
            SelectedDate = "";
            ServiceTime = service_time;
            holidays = response.holidays
            createDate(response)
            var CloseTime = [];
            var dt = moment();
            SelectedDate = dt.format("YYYY-MM-DD");
            var day_name = dt.locale('en').format('ddd');

            if (use_service_time) {
                BookingServiceTime = response.service.service_time;
            }

            if (countObj(response.location) > 0) {
                //Close day control from location.
                timeList = response['location'].Days;
                CloseTime = timeList[day_name];
            }

            if (countObj(response.staff) > 0) {
                staffData = response.staff;
            }
            if (countObj(response.booking) > 0) {
                bookingData = response.booking;
            }
            if (CloseTime != undefined && holidayCheck(SelectedDate) == false) {
                createTime('#timeSelect', CloseTime, day_name, SelectedDate);
            } else {
                $('#timeSelect').html('<div class="alert alert-default alert-time" role="alert">\n' +
                    '<h4 class="alert-heading">' +
                    '<i class="fa fa-exclamation-triangle"></i>' +
                    close_day_msg +
                    '</h4>\n' +
                    '</div>');
            }
        }

    })
}

function sendData(name, val, async, callback) {
    $.ajax({
        type: "GET",
        async: async,
        data: 'name=' + name + '&val=' + val,
        url: "/srv/" + name,
        success: function (response) {
            callback(response);
        },

    });
}

function responseInput(response) {
    $('.body_' + response.type + ' .input').html("");
    var photo_url;
    if (response.type == "staff" && response.items.length > 0) {
        $('.body_' + response.type + ' .input').html($('.body_' + response.type + ' .input').html() +
            createInput(0, any_staff_name, response.type, any_staff_image_url))
    }
    $.each(response.items, function (key, value) {
        if (value.photo_url != undefined) photo_url = value.photo_url;
        if (response.type == "service" && value.price) value.name = value.name + " - " + value.price + currency;
        $('.body_' + response.type + ' .input').html($('.body_' + response.type + ' .input').html() +
            createInput(value.id, value.name, response.type, photo_url, value.description))
    });
}

function createDate(date) {
    let CloseDays;
    if (date['location'].Days.closeDays.length > 0) {
        CloseDays = date['location'].Days.closeDays.toString();
    }

    $('#paginator-start-end').datepaginator({
        startDate: formatDate(new Date()),
        itemWidth: 120,
        selectedItemWidth: 138,
        offDays: CloseDays,
        width: 3900,
        endDate: formatDate(moment().add(bookingDateLimit, 'days')),
        showCalendar: false,
    });

    $('#paginator-start-end').on('selectedDateChanged', function (event, date) {
        var dt = moment(date, "YYYY-MM-DD");
        SelectedDate = dt.format("YYYY-MM-DD");
        var day_name = dt.locale('en').format('ddd');
        if (countObj(timeList) > 0 && timeList[day_name] !== undefined && holidayCheck(SelectedDate) === false) {
            createTime('#timeSelect', timeList[day_name], day_name, SelectedDate);
        } else {
            $('#timeSelect').html('<div class="alert alert-default alert-time" role="alert">\n' +
                '<h4 class="alert-heading">' +
                '<i class="fa fa-exclamation-triangle"></i>' +
                close_day_msg +
                '</h4>\n' +
                '</div>');
        }
    });

    var swiper = new Swiper("#paginator-start-end", {
        slidesPerView: 4,
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
        },
    });
}

function holidayCheck(selectedDate) {
    let isHoliday = 0;
    holidays.map((holiday) => {
        if (selectedDate <= (holiday.finish_date).slice(0,10) && selectedDate >= holiday.date.slice(0,10)) {
            isHoliday++;
        }
    });
    return isHoliday !== 0;
}

function dateParse(time) {
    return moment(SelectedDate + " " + time + ":00", 'YYYY-MM-DD HH:mm:ss');
}

function createTime(selector, time, day_name, selectedDate) {
    if (time != undefined) {
        var select = $(selector);
        var startTime = 600;
        var endTime = 1080;
        if (countObj(time) > 0) startTime = createTimeStartEndFormat(time['start']);
        if (countObj(time) > 0) endTime = createTimeStartEndFormat(time['end']);

        // if (BookingServiceTime > service_time) {
        //     // endTime = createTimeStartEndFormat(time['end']);
        //     endTime = endTime - (BookingServiceTime - service_time);
        // }

        select.html("");
        var hours, minutes, staffTodayStart, stafftodayEnd, staffTodayStartNoon, stafftodayEndNoon,
            timeAvaliableForStaffNoon, timeAvaliableForStaff;

        var curDate = moment(SelectedDate);
        var dayNameArr = days[curDate.format('d')];

        // Staff working hours
        if ($('input[name="staff_id"]').val() == 0) {
            staffTodayStart = undefined;
            stafftodayEnd = undefined;

            staffTodayStartNoon = undefined;
            stafftodayEndNoon = undefined;

            $.each(staffData, function (index, staff) {
                if (staff[dayNameArr + "Start"] != "00:00:00" && staff[dayNameArr + "Start"] != null) {
                    if (staffTodayStart !== undefined) {
                        if (dateParse(staff[dayNameArr + "Start"]).format('x') < staffTodayStart.format('x')) {
                            staffTodayStart = dateParse(staff[dayNameArr + "Start"]);
                        }
                        if (dateParse(staff[dayNameArr + "End"]).format('x') > stafftodayEnd.format('x')) {
                            stafftodayEnd = dateParse(staff[dayNameArr + "End"]);
                        }
                    } else {
                        staffTodayStart = dateParse(staff[dayNameArr + "Start"]);
                        stafftodayEnd = dateParse(staff[dayNameArr + "End"]);
                    }
                }

            });
        } else {
            staffTodayStart = dateParse(staffData[dayNameArr + "Start"]);
            stafftodayEnd = dateParse(staffData[dayNameArr + "End"]);
            // Noon break for staff
            staffTodayStartNoon = dateParse(staffData[dayNameArr + "StartNoon"]);
            stafftodayEndNoon = dateParse(staffData[dayNameArr + "EndNoon"]);
        }

        for (var i = startTime; i < endTime; i += ServiceTime) {
            hours = Math.floor(i / 60);
            minutes = i % 60;
            if (minutes < 10) {
                minutes = '0' + minutes;
            }
            if (hours < 10) {
                hours = '0' + hours;
            }
            var time = hours + ':' + minutes;
            var selectedDateTime = dateParse(time);
            let n_minutes = parseInt(minutes) + parseInt(BookingServiceTime);
            let n_selectedDateTime = selectedDateTime;

            // Check if any noon hours for staff
            timeAvaliableForStaffNoon = 0;  // staff not available for this time period.
            if ($('input[name="staff_id"]').val() != 0) {
                if (staffTodayStartNoon.format('x') <= selectedDateTime.format('x') && stafftodayEndNoon.format('x') > selectedDateTime.format('x')) {
                    timeAvaliableForStaffNoon = 1; // staff available for this time period.
                }

                // if (n_selectedDateTime.format('x') > staffTodayStartNoon.format('x')
                //     &&
                //     stafftodayEndNoon.format('x') > selectedDateTime.format('x')) {
                //     timeAvaliableForStaffNoon = 1; // staff available for this time period.
                // }
            }

            // check if staff is working or not?
            timeAvaliableForStaff = 0;  // staff not available for this time period.
            if (staffTodayStart.format('x') <= selectedDateTime.format('x') && stafftodayEnd.format('x') > selectedDateTime.format('x')) {
                timeAvaliableForStaff = 1; // staff available for this time period.
            }

            //Mesai bitimine sarkıyor ise alanı kapat
            timeAvaliableForServiceTime = 1;
            if ((parseInt(selectedDateTime.format('x')) + (60*  parseInt(BookingServiceTime)*1000)) > getDayClose(endTime).format('x')) {
                timeAvaliableForServiceTime = 0;
            }

            var timeAvaliableForBooking = 0;
            //Staff Any olarak seçilmiş ise
            if ($('input[name="staff_id"]').val() == 0) {
                var timeAvaliableForBooking_Array = [];
                //Tüm Staff'ları Döndür

                $.each(bookingData, function (staff_id, booking_staff_data) {
                    // Staff ilgili gün çalışıyor mu?
                    if (staffData[staff_id][dayNameArr + "Start"] != "00:00:00" && staffData[staff_id][dayNameArr + "Start"] != null) {
                        //Staff'ı saatini seçilebilir yap
                        timeAvaliableForBooking_Array[staff_id] = false;

                        //Staffların Bookings döndür
                        $.each(booking_staff_data, function (index, value) {
                            var dateTimeCurrentSlot = dateParse(time);

                            const booking_datetime_start = moment(value.booking_datetime_start),
                                booking_datetime_end = moment(value.booking_datetime_end),

                                geriyegit = booking_datetime_start.subtract(ServiceTime - 1, "minutes"),
                                baslangic = booking_datetime_start.subtract(1, "minutes"),
                                backwardTime = moment(dateTimeCurrentSlot).isBetween(geriyegit, booking_datetime_start),
                                forwardTime = moment(dateTimeCurrentSlot).isBetween(baslangic, booking_datetime_end)
                            if (backwardTime || forwardTime) {
                                //Staff ı uygun Değil olarak işaretle
                                timeAvaliableForBooking_Array[staff_id] = true;
                            }
                        });
                    }
                });

                //Çalışma saatleri uygun olmayan staff'ları kaldır.
                $.each(timeAvaliableForBooking_Array, function (staff_id, status_for_time) {
                    if (status_for_time !== undefined) {
                        var iseBaslangic = dateParse(staffData[staff_id][dayNameArr + "Start"]);
                        var isBitis = dateParse(staffData[staff_id][dayNameArr + "End"]);

                        calismaSaati = moment(selectedDateTime).isBetween(iseBaslangic, isBitis, null, '[)')
                        if (calismaSaati === false) {
                            timeAvaliableForBooking_Array[staff_id] = undefined;
                        }
                    }
                });

                //Eğer hiçbir bir staff müsait değil ise saati kapat
                if (jQuery.inArray(false, timeAvaliableForBooking_Array) === -1) {
                    timeAvaliableForBooking = 1;
                }

            } else {
                //Staff Seçilmiş ise
                $.each(bookingData, function (index, value) {
                    var dateTimeCurrentSlot = dateParse(time);

                    const booking_datetime_start = moment(value.booking_datetime_start),
                        booking_datetime_end = moment(value.booking_datetime_end),

                        geriyegit = booking_datetime_start.subtract(ServiceTime - 1, "minutes"),
                        baslangic = booking_datetime_start.subtract(1, "minutes"),
                        backwardTime = moment(dateTimeCurrentSlot).isBetween(geriyegit, booking_datetime_start),
                        forwardTime = moment(dateTimeCurrentSlot).isBetween(baslangic, booking_datetime_end)

                    if (backwardTime || forwardTime) {
                        timeAvaliableForBooking = 1;
                    }
                });
            }

            var disabled = '';
            if (!timeAvaliableForServiceTime || !timeAvaliableForStaff || timeAvaliableForStaffNoon || timeAvaliableForBooking || selectedDateTime.isBefore(now.format('YYYY-MM-DD HH:mm'))) {
                disabled = 'disabled';
            }
            select.append(createTimeInput('time', time, disabled));
        }
    }
}

function createTimeInput(type, name, disabled) {
    var input = '<button class="btn btn-default btn-time notranslate" name="time"\n' +
        disabled + ' required type="button" onclick="selectedTime(this)">\n' +
        name + '</button>';

    return input;

}

function formatDate(date) {
    var m = moment(date),
        month1 = '' + (m.format('M')),
        day1 = '' + m.format('DD'),
        year1 = parseInt(m.format('YYYY'));

    if (month1.length < 2) month1 = '0' + month1;
    if (day1.length < 2) day1 = '0' + day1;

    return [year1, month1, day1].join('-');
}

function createTimeStartEndFormat(time) {
    time = time.split(':');
    return parseInt(time[0]) * 60 + parseInt(time[1])
}


function selectedTime(element) {
    $('.btn-time').removeClass('selected-Time');
    $(element).addClass('selected-Time');
    var DateTime = $.trim(SelectedDate) + " " + $.trim($(element).html());
    createBreadCrumb(DateTime, 5)
    $('input[name="select_time"]').val(DateTime);
}


function countObj(x) {
    var that = x,
        count = 0;
    for (property in that) {
        if (that.hasOwnProperty(property)) {
            count++;
        }
    }
    return count;
}


function crud(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        async: false,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}


function selectedService(service, back) {
    crud('', '/ajax/getService/' + service, 'POST', function (callback) {
        if (callback.data != null && callback.data.gift == true) {
            $('.dateSelector, #timeSelect').addClass('hidden');
            $('input[name="select_time"]').val("0000-00-00 00:00")
            $('input[name="staff_id"]').val("null")
            back("skipStaff");
        }
    })
}

function setInputFilter(textbox, inputFilter) {
    ["input", "keydown", "keyup", "mousedown", "mouseup", "select", "contextmenu", "drop"].forEach(function (event) {
        textbox.addEventListener(event, function () {
            if (inputFilter(this.value)) {
                this.oldValue = this.value;
                this.oldSelectionStart = this.selectionStart;
                this.oldSelectionEnd = this.selectionEnd;
            } else if (this.hasOwnProperty("oldValue")) {
                this.value = this.oldValue;
                this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
            } else {
                this.value = "";
            }
        });
    });
}

setInputFilter(document.getElementById("phoneNumberInput"), function (value) {
    return /^\d*$/.test(value);
});

function getDayClose(time) {
    hours = Math.floor(time / 60);
    minutes = time % 60;
    if (minutes < 10) {
        minutes = '0' + minutes;
    }
    if (hours < 10) {
        hours = '0' + hours;
    }
    time = hours + ':' + minutes;
    return dateParse(time);
}
