<?php

return [
    'color' => [
        'type' => 'anomaly.field_type.colorpicker',
        'config' => [
            'default_value' => "#317ae2",
        ],
    ],
    'panel_color' => [
        'type' => 'anomaly.field_type.colorpicker',
        'config' => [
            'default_value' => "#2c3e50",
        ],
    ],
    'panel_border_color' => [
        'type' => 'anomaly.field_type.colorpicker',
        'config' => [
            'default_value' => "#2c3e50",
        ],
    ],
    'booking_accent_color' => [
        'type' => 'anomaly.field_type.colorpicker',
        'config' => [
            'default_value' => "#db0077",
        ],
    ],
    'sms_notify' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ],
    ],
    'home_message_send_location' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\BookingModule\Location\LocationModel::class,
            'default_value' => null,
        ],
    ],
    'home_message' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => '...',
        ],
    ],
    'activation_sms_notify' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ],
    ],
    // Profile settings
    'password_sms_notify' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ],
    ],

    'bookingDateLimit' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            "default_value" => 7,
            "min" => 2,
            "max" => 365,
        ],
    ],
    'paypal' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => false
        ]
    ],

    'staff_title' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'Staff',
        ],
    ],
    'any_staff_title' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'Any Staff',
        ],
    ],
    'activation_system' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ],
    ],

    // reCAPTCHA
    'google_captcha_site_key' => [
        'type' => 'anomaly.field_type.text',
    ],
    'google_captcha_secret_key' => [
        'type' => 'anomaly.field_type.text',
    ],
    "score_threshold" => [
        "type"   => "anomaly.field_type.decimal",
        "config" => [
            "default_value" => 0.5,
            "decimals"  => 1,
            "min"       => 0.0,
            "max"       => 1.0,
        ]
    ],
    'service_time' => [
        'type' => 'anomaly.field_type.integer',
        "required" => true,
        'config' => [
            "default_value" => 15,
        ],
    ],

    'select_payment_type' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ],
    ],
    'repeatable_booking' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ],
    ],
    'use_service_time' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ],
    ],
    'show_paypal_icon' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ],
    ],
];
