<?php namespace Visiosoft\BookingModule\Booking\Book;

use Visiosoft\BookingModule\Rules\ReCaptchaRule;

class BookFormFields
{
    public function handle(BookFormBuilder $builder)
    {
        $captchaSiteKey = setting_value('visiosoft.module.booking::google_captcha_site_key');
        $captchaSecretKey = setting_value('visiosoft.module.booking::google_captcha_secret_key');

        $register = [];
        if ($captchaSiteKey && $captchaSecretKey) {
            $register = [
                'recaptcha_token' => [
                    'required' => true,
                    'type' => 'anomaly.field_type.text',
                    'config' => [
                        "max" => 0,
                    ],
                    'rules' => [
                        'valid_recaptcha'
                    ],
                    'validators' => [
                        'valid_recaptcha' => [
                            'message' => false,
                            'handler' => ReCaptchaRule::class
                        ]
                    ]
                ],
            ];
        }

        $user = auth()->user();
        $builder->setFields(
            array_merge(
                $register,
                [
                    'payment_type' => [
                        'type' => 'select',
                        'label' => trans('visiosoft.module.booking::field.payment_type.name'),
                        'required' => true,
                        'config' => [
                            'options' => [
                                'cash' => trans('visiosoft.module.booking::field.cash.name'),
                                'paypal' => trans('visiosoft.module.booking::field.paypal.name'),
                            ],
                            'min' => 5
                        ]
                    ],
                    'username' => [
                        'type' => 'text',
                        'required' => true,
                        'label' => trans('visiosoft.module.booking::field.name.name'),
                        'value' => $user ? $user->display_name : '',
                        'config' => [
                            'min' => 3
                        ]
                    ],
                    'service_id' => [
                        'type' => 'text',
                        'required' => true,
                        'class' => 'hidden'
                    ],
                    'create_user' => [
                        'type' => 'boolean',
                        'label' => trans('visiosoft.module.booking::field.create_user.name'),
                    ],
                    'select_time' => [
                        'type' => 'text',
                        'class' => 'hidden'
                    ],
                    'location_id' => [
                        'type' => 'text',
                        'required' => true,
                        'class' => 'hidden'
                    ],
                    'staff_id' => [
                        'type' => 'text',
                        'required' => true,
                        'class' => 'hidden'
                    ],
                    'email' => [
                        'type' => 'email',
                        'label' => trans('visiosoft.module.booking::field.email.name'),
                        'value' => $user ? $user->email : ''
                    ],
                    'phone' => [
                        'required' => true,
                        'type' => 'text',
                        'label' => trans('visiosoft.module.booking::field.phone.name'),
                        'value' => $user ? $user->phone_number : '',
                        'placeholder' => '4912345678901'
                    ],
                ]
            )
        );
    }
}
