<?php namespace Visiosoft\BookingModule\Booking;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class BookingExport implements WithMapping, FromCollection, WithHeadings
{
	public function collection()
	{
		$booking = new BookingModel();

        $booking = $booking->newQuery()
			->leftJoin('booking_staff', 'booking_booking.staff_id', 'booking_staff.id')
			->select(['booking_booking.*', 'booking_staff.name as staff'])
			->get();

		return $booking;
	}

	public function map($booking): array
	{
		return [
            $booking->id,
            $booking->booking_datetime_start,
            $booking->staff,
            $booking->tc_number,
            $booking->phone,
            $booking->name,
            $booking->surname,
            $booking->father_name,
            $booking->mevcut_tapu_ada,
            $booking->mevcut_tapu_parsel,

		];
	}

	public function headings(): array
	{
		return [
			'ID',
			'Rezervasyon Tarihi',
			'Personel',
			'Tc Kimlik Numarası',
			'Telefon Numarası',
			'Adı',
			'Soyadı',
			'Baba Adı',
			'Mevcut Tapu Ada',
			'Mevcut Tapu Parsel',
		];
	}
}
