<?php namespace Visiosoft\BookingModule\Booking\Table\Component\View\Type;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Ui\Table\Component\View\Query\AllQuery;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;


class Table extends View
{


    protected $slug = 'table';


    protected $text = 'visiosoft.module.booking::view.table';


    protected $icon = 'fa fa-list-ul';


    protected $columns = [
        'staff',
        'booking_datetime_start',
        'name',
        'phone',
        'email',
        'services_select' => [
            'value' =>
                '{% if entry.services_select == setting_value("visiosoft.module.booking::gift_card_service") %} ' .
                '<font color="red">{{ trans("visiosoft.module.booking::button.gift_card") }}</font> - ' .
                '{{ findService(entry.services_select).name }}' .
                ' {% else %}' .
                ' {{ findService(entry.services_select).name }}' .
                ' {% endif %}',
        ],
    ];


    protected $buttons = [
        'edit'
    ];


    public $assets = [];


    public $options = [];


    protected $query = AllQuery::class;

}
