<?php namespace Visiosoft\BookingModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class BookingModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-calendar';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'booking' => [
            'href' => '/admin/booking',
        ],
        'locations' => [
            'buttons' => [
                'new_location',
            ],
        ],
        'services' => [
            'buttons' => [
                'new_service',
            ],
        ],
        'staff' => [
            'buttons' => [
                'new_staff',
            ],
        ],
        'holidays' => [
            'buttons' => [
                'new_holiday',
                'new_lunch_break' => [
                    'type' => 'success',
                    'href' => '/admin/booking/holidays/create-lunch-break'
                ],
            ],
        ],
    ];

}
