var dateList = [];
var timeList = [];
var date = [];
var SelectedDate;
var ServiceTime = 20;


$(document).ready(function () {
    if (!APP_DEBUG) {
        console = console || {};
        console.log = function () {
        };
    }

    var inputQuery = document.querySelector("input[name=\"phone\"]");
    var iti = intlTelInput(inputQuery, {
        hiddenInput: "full_phone",
        initialCountry: "auto",
        geoIpLookup: function (success, failure) {
            $.get("https://ipinfo.io", function () {
            }, "jsonp").always(function (resp) {
                var countryCode = (resp && resp.country) ? resp.country : "";
                success(countryCode);
            });
        }
    });

    var navListItems = $('div.setup-panel div a'),
        allWells = $('.setup-content'),
        parameters = {};

    allWells.hide();

    navListItems.click(function (e) {
        e.preventDefault();
        var $target = $($(this).attr('href')),
            $item = $(this);

        if (!$item.hasClass('disabled')) {
            navListItems.removeClass('btn-success').addClass('btn-default');
            $item.addClass('btn-success');
            allWells.hide();
            $target.show();
            $target.find('input:eq(0)').focus();
        }
    });

    $(document).on('click', '.instant-next', function () {
        var curStep = $(this).closest(".setup-content"),
            curStepBtn = curStep.attr("id"),
            nextStepWizard = $('div.setup-panel div a[href="#' + curStepBtn + '"]').parent().next().children("a"),
            curInputs = curStep.find("input[type='text'],input[type='url'],input[type='radio']"),
            isValid = true;

        $(".form-group").removeClass("has-error");

        for (var i = 0; i < curInputs.length; i++) {
            if (!curInputs[i].validity.valid) {
                isValid = false;
                $(curInputs[i]).closest(".form-group").addClass("has-error");
            }
        }
        var btn = $(this).closest(".panel-body").children("input"),
            ItemType = btn.attr('name'),
            CheckedItem = $("input[name='" + ItemType + "_input']:checked"),
            Value = CheckedItem.val(),
            ItemText = CheckedItem.parent().find('label').text();

        parameters[ItemType] = Value;

        if (btn.hasClass('send')) {
            if (isValid) renderData(ItemType, Value);
        }

        if (btn.hasClass('getBooking')) {
            if (isValid) renderData(ItemType, JSON.stringify(parameters));
        }

        if (isValid) {
            $('input[name="' + ItemType + '_id"]').val(Value);
            createBreadCrumb(ItemText, curStepBtn);
            nextStepWizard.removeAttr('disabled').trigger('click');
        }

    });

    $('div.setup-panel div a.btn-success').trigger('click');
});

function createBreadCrumb(value, step) {
    if ($(".breadcrumb-" + step).length == 0) {
        $('.booking-breadcrumb').html($('.booking-breadcrumb').html() + '<li class="booking-breadcrumb-active breadcrumb-' + step + '" data-step="' + step + '"><a>' + value + '</a></li>');
    } else {
        $(".breadcrumb-" + step + " a").html(value);
    }
}

function createInput(id, name, type, photo = "") {
    var input = "";
    if (type == "staff") input += '<div class=\'col-xs-12 row\' style=\'margin:auto;border-bottom: 1px solid #333;margin-bottom: 23px;\'>' +
        '<div class="col-xs-2 no-padding img-mobile-book" style="min-height: 130px"><img class="staff-img" src="' + photo + '"/></div>' +
        '<div class="col-xs-8 col-md-10 no-padding pull-right checkbox-mobile-book" style="min-height: 130px">';

    input += '<div class="funkyradio">\n<div class="funkyradio-warning">\n' +
        '<input class="instant-next" type="radio" id="' + type + id + '" name="' + type + '_input"\n required value="' + id + '"/>\n' +
        '<label for="' + type + id + '">' + name + '</label>\n' +
        '</div>\n</div>';
    if (type == "staff") input += '</div></div>';

    return input
}

function renderData(name, val) {
    sendData(name, val, function (response) {
        if (response.type != undefined) {
            responseInput(response);
        } else {
            dateList = [];
            timeList = [];
            date = [];
            SelectedDate = "";
            ServiceTime = 20;
            removeDateList(response)
            createDate(response)
            var CloseTime = [];
            var dt = moment(new Date(), "YYYY-MM-DD HH:mm:ss")
            SelectedDate = dt.format("YYYY-MM-DD");
            var day_name = dt.format('ddd');
            ServiceTime = response.service.service_time;

            if (countObj(response.location) > 0) {
                timeList = response['location'].Days;
                CloseTime = timeList[day_name];
            }
            if (CloseTime != undefined)
                createTime('#timeSelect', CloseTime, day_name);
            else
                $('#timeSelect').html('<div class="alert alert-default alert-time" role="alert">\n' +
                    '<h4 class="alert-heading">' +
                    '<i class="fa fa-exclamation-triangle"></i>' +
                    close_day_msg +
                    '</h4>\n' +
                    '</div>');
        }

    })
}

function sendData(name, val, callback) {
    $.ajax({
        type: "GET",
        data: 'name=' + name + '&val=' + val,
        url: "/srv/" + name,
        success: function (response) {
            callback(response);
        },

    });
}

function responseInput(response) {
    $('.body_' + response.type + ' .input').html("");
    var photo_url;
    $.each(response.items, function (key, value) {
        if (value.photo_url != undefined) photo_url = value.photo_url;
        if (response.type == "service") value.name = value.name + " - " + value.price + currency;
        $('.body_' + response.type + ' .input').html($('.body_' + response.type + ' .input').html() +
            createInput(value.id, value.name, response.type, photo_url))
    });
}

function removeDateList(response) {

    $.each(response.booking, function (key, value) {
        var response_datetime = new Date(value.booking_datetime_start);
        var dayName = moment(response_datetime, "YYYY-MM-DD HH:mm:ss").format('ddd');
        date[dayName] = [];
    });
    $.each(response.booking, function (key, value) {
        var response_datetime = new Date(value.booking_datetime_start);
        var dayName = moment(response_datetime, "YYYY-MM-DD HH:mm:ss").format('ddd');
        var Hours = response_datetime.getHours();
        var Min = response_datetime.getMinutes();
        if (Min == 0) Min = "00";
        date[dayName][key] = Hours + ":" + Min;
        dateList[dayName] = date[dayName];
    });
}

function createDate(date) {
    var CloseDays;
    if (date.length > 0) {
        CloseDays = date[0].Days.closeDays.toString();
    }

    $('#paginator-start-end').datepaginator({
        startDate: formatDate(new Date()),
        itemWidth: 200,
        selectedItemWidth: 200,
        offDays: CloseDays,
        endDate: formatDate(new Date((new Date()).valueOf() + 1000 * 3600 * (24 * 6))),
    });

    $('#paginator-start-end').on('selectedDateChanged', function (event, date) {
        var dt = moment(date, "YYYY-MM-DD");
        SelectedDate = dt.format("YYYY-MM-DD");
        var day_name = dt.format('ddd');

        if (countObj(timeList) > 0 && timeList[day_name] != undefined) {
            createTime('#timeSelect', timeList[day_name], day_name);
        } else {
            $('#timeSelect').html('<div class="alert alert-default alert-time" role="alert">\n' +
                '<h4 class="alert-heading">' +
                '<i class="fa fa-exclamation-triangle"></i>' +
                close_day_msg +
                '</h4>\n' +
                '</div>');
        }
    });
}


function createTime(selector, time, day_name) {
    if (time != undefined) {
        var select = $(selector);
        var startTime = 600;
        var endTime = 1080;
        if (countObj(time) > 0) startTime = createTimeStartEndFormat(time['start']);
        if (countObj(time) > 0) endTime = createTimeStartEndFormat(time['end']);
        select.html("");
        var hours, minutes;
        for (var i = startTime; i < endTime; i += ServiceTime) {
            hours = Math.floor(i / 60);
            minutes = i % 60;
            if (minutes < 10) {
                minutes = '0' + minutes;
            }
            var time = hours + ':' + minutes;
            if ($.inArray(time, dateList[day_name]) < 0) {
                select.append(createTimeInput('time', time, ''));
            } else {
                select.append(createTimeInput('time', time, 'disabled'));
            }
        }
    }
}

function createTimeInput(type, name, disabled) {
    var input = '<button class="btn btn-default btn-time" name="time"\n' +
        disabled + ' required type="button" onclick="selectedTime(this)">\n' +
        name + '</button>';

    return input;

}

function formatDate(date) {
    var d = new Date(date),
        month = '' + (d.getMonth() + 1),
        day = '' + d.getDate(),
        year = d.getFullYear();

    if (month.length < 2) month = '0' + month;
    if (day.length < 2) day = '0' + day;

    return [year, month, day].join('-');
}

function createTimeStartEndFormat(time) {
    time = time.split(':');
    return parseInt(time[0]) * 60 + parseInt(time[1])
}


function selectedTime(element) {
    $('.btn-time').removeClass('selected-Time');
    $(element).addClass('selected-Time');
    var DateTime = $.trim(SelectedDate) + " " + $.trim($(element).html());
    createBreadCrumb(DateTime, 5)
    $('input[name="select_time"]').val(DateTime);
}

$('#booking-form').submit(function (e) {
    if ($('input[name="select_time"]').val() == "") {
        e.preventDefault();
    }
});


function countObj(x) {
    var that = x,
        count = 0;
    for (property in that) {
        if (that.hasOwnProperty(property)) {
            count++;
        }
    }
    return count;
};