<?php namespace Visiosoft\BookingModule\Service;

use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Visiosoft\BookingModule\Service\Contract\ServiceInterface;
use Anomaly\Streams\Platform\Model\Booking\BookingServicesEntryModel;

class ServiceModel extends BookingServicesEntryModel implements ServiceInterface
{
    public function getServiceTime($service_id)
    {
        return $this->find($service_id)->time;
    }

    public function addFotoService($items)
    {
        foreach ($items as $key => $item) {
            $items[$key]['photo_url'] = $this->getPhoto($item['id']);
        }
        return $items;
    }

    public function getPhoto($service_id)
    {
        $service = $this->find($service_id);
        if ($service && ($photo = $service->photo)) {
            return url('files/images/' . $photo->name);
        }
        return $this->dispatch(new MakeImageInstance('visiosoft.module.booking::img/unnamed.png', 'img'))->url();
    }

    public function addServiceTime($id)
    {
        $service['service_time'] = $this->getServiceTime($id);
        $service ['location_id'] = $this->getLocationID($id);
        return $service;
    }

    public function getLocationID($id)
    {
        return $this->find($id)->location_id;
    }

    public function getServicePrice($id)
    {
        return $this->find($id)->price;
    }

    public function getServiceName($id)
    {
        return $this->find($id)->name;
    }

    public function getServices($id = null)
    {
        if ($id == null) return $this->get();
        return $this->find($id);
    }

    public function findLocationServices($location_id)
    {
        return $this->where('location_id', $location_id)->get();
    }

    public function findServiceParam($column, $value)
    {
        return $this->where($column, $value)->first();
    }

    public function getLocation()
    {
        return $this->location;
    }


}
